/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.interceptor.Interceptor;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.BeansInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.cdi.StartupObject;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;

public class CdiScanner
implements ScannerService {
    private final Set<Class<?>> classes = new HashSet();

    public Set<String> getAllAnnotations(String className) {
        return Collections.emptySet();
    }

    public void init(Object object) {
        if (!(object instanceof StartupObject)) {
            return;
        }
        StartupObject startupObject = (StartupObject)object;
        AppInfo appInfo = startupObject.getAppInfo();
        ClassLoader classLoader = startupObject.getAppContext().getClassLoader();
        WebBeansContext webBeansContext = startupObject.getAppContext().getWebBeansContext();
        AlternativesManager alternativesManager = webBeansContext.getAlternativesManager();
        DecoratorsManager decoratorsManager = webBeansContext.getDecoratorsManager();
        InterceptorsManager interceptorsManager = webBeansContext.getInterceptorsManager();
        HashSet<String> ejbClasses = new HashSet<String>();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                ejbClasses.add(bean.ejbClass);
            }
        }
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            Class clazz;
            BeansInfo beans = ejbJar.beans;
            if (beans == null) continue;
            for (String className : beans.interceptors) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    if (AnnotationUtil.hasAnnotation((Annotation[])clazz.getDeclaredAnnotations(), Interceptor.class) && !annotationManager.hasInterceptorBindingMetaAnnotation(clazz.getDeclaredAnnotations())) {
                        throw new WebBeansConfigurationException("Interceptor class : " + clazz.getName() + " must have at least one @InterceptorBindingType");
                    }
                    if (interceptorsManager.isInterceptorEnabled(clazz)) {
                        throw new WebBeansConfigurationException("Interceptor class : " + clazz.getName() + " is already defined");
                    }
                    interceptorsManager.addNewInterceptor(clazz);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load interceptor class: " + className);
            }
            for (String className : beans.decorators) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    if (decoratorsManager.isDecoratorEnabled(clazz)) {
                        throw new WebBeansConfigurationException("Decorator class : " + clazz.getName() + " is already defined");
                    }
                    decoratorsManager.addNewDecorator(clazz);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load decorator class: " + className);
            }
            for (String className : beans.alternativeStereotypes) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    alternativesManager.addStereoTypeAlternative(clazz, null, null);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load alternativeStereotype class: " + className);
            }
            for (String className : beans.alternativeClasses) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    alternativesManager.addClazzAlternative(clazz, null, null);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load alternative class: " + className);
            }
            for (String className : beans.managedClasses) {
                if (ejbClasses.contains(className) || (clazz = this.load(className, classLoader)) == null) continue;
                this.classes.add(clazz);
            }
        }
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return false;
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    private Class load(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public void scan() {
    }

    public Set<URL> getBeanXmls() {
        return Collections.emptySet();
    }

    public Set<Class<?>> getBeanClasses() {
        return this.classes;
    }

    public void release() {
        this.classes.clear();
    }
}

