/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitEvent;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configure
extends InstallableUnitPhase {
    public Configure(int weight) {
        super(PhaseSetFactory.PHASE_CONFIGURE, weight);
    }

    @Override
    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null;
    }

    @Override
    protected List<ProvisioningAction> getActions(InstallableUnitOperand currentOperand) {
        List<ProvisioningAction> parsedActions;
        IInstallableUnit unit = currentOperand.second();
        BeforeConfigureEventAction beforeAction = new BeforeConfigureEventAction();
        AfterConfigureEventAction afterAction = new AfterConfigureEventAction();
        Touchpoint touchpoint = this.getActionManager().getTouchpointPoint(unit.getTouchpointType());
        if (touchpoint != null) {
            beforeAction.setTouchpoint(touchpoint);
            afterAction.setTouchpoint(touchpoint);
        }
        ArrayList<ProvisioningAction> actions = new ArrayList<ProvisioningAction>();
        actions.add(beforeAction);
        if (!QueryUtil.isFragment((IInstallableUnit)unit) && (parsedActions = this.getActions(unit, this.phaseId)) != null) {
            actions.addAll(parsedActions);
        }
        actions.add(afterAction);
        return actions;
    }

    @Override
    protected String getProblemMessage() {
        return Messages.Phase_Configure_Error;
    }

    @Override
    protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map<String, Object> parameters, IProgressMonitor monitor) {
        IInstallableUnit iu = operand.second();
        monitor.subTask(NLS.bind((String)Messages.Phase_Configure_Task, (Object)iu.getId()));
        parameters.put("iu", iu);
        Collection artifacts = iu.getArtifacts();
        if (artifacts != null && artifacts.size() > 0) {
            parameters.put("artifact", artifacts.iterator().next());
        }
        return Status.OK_STATUS;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AfterConfigureEventAction
    extends ProvisioningAction {
        AfterConfigureEventAction() {
        }

        @Override
        public IStatus execute(Map<String, Object> parameters) {
            Profile profile = (Profile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            ((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, false, profile, iu, 3, this.getTouchpoint()));
            return null;
        }

        @Override
        public IStatus undo(Map<String, Object> parameters) {
            IProfile profile = (IProfile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            ((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, true, profile, iu, 2, this.getTouchpoint()));
            return null;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BeforeConfigureEventAction
    extends ProvisioningAction {
        BeforeConfigureEventAction() {
        }

        @Override
        public IStatus execute(Map<String, Object> parameters) {
            IProfile profile = (IProfile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            ((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, true, profile, iu, 3, this.getTouchpoint()));
            return null;
        }

        @Override
        public IStatus undo(Map<String, Object> parameters) {
            Profile profile = (Profile)parameters.get("profile");
            String phaseId = (String)parameters.get("phaseId");
            IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            ((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME)).publishEvent((EventObject)new InstallableUnitEvent(phaseId, false, profile, iu, 2, this.getTouchpoint()));
            return null;
        }
    }
}

