/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.osgi;

import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;

public class OSGiLogServiceListener
implements LogListener {
    private final Logger logger;

    public OSGiLogServiceListener(Logger logger) {
        this.logger = logger;
    }

    public void logged(LogEntry entry) {
        if (entry.getException() == null) {
            this.log(entry.getLevel(), this.formatMessage(entry));
        } else {
            this.log(entry.getLevel(), this.formatMessage(entry), entry.getException());
        }
    }

    private String formatMessage(LogEntry entry) {
        String message = entry.getMessage();
        if (entry.getServiceReference() != null) {
            message = String.format("Service %s, %s", entry.getServiceReference().getProperty("service.id").toString(), message);
        }
        if (entry.getBundle() != null) {
            message = String.format("Bundle %s_%s, %s", entry.getBundle().getSymbolicName(), entry.getBundle().getVersion().toString(), message);
        }
        return message;
    }

    private void log(int level, String message) {
        switch (level) {
            case 4: {
                this.logger.debug(message);
                break;
            }
            case 3: {
                this.logger.info(message);
                break;
            }
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.error(String.format("Log Message of unknown severity %d: %s", level, message));
            }
        }
    }

    private void log(int level, String message, Throwable exception) {
        switch (level) {
            case 4: {
                this.logger.debug(message, exception);
                break;
            }
            case 3: {
                this.logger.info(message, exception);
                break;
            }
            case 2: {
                this.logger.warn(message, exception);
                break;
            }
            case 1: {
                this.logger.error(message, exception);
                break;
            }
            default: {
                this.logger.error(String.format("Log Message of unknown severity %d: %s", level, message), exception);
            }
        }
    }
}

