/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.serviceability.dump.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class RegionDigraphDumpContributor
implements DumpContributor {
    private final BundleContext bundleContext;

    public RegionDigraphDumpContributor(@NonNull BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        File outputFile = dump.createFile("region.digraph");
        ServiceReference serviceReference = this.bundleContext.getServiceReference(RegionDigraph.class);
        RegionDigraph regionDigraph = (RegionDigraph)this.bundleContext.getService(serviceReference);
        try {
            try (FileOutputStream output = new FileOutputStream(outputFile);){
                regionDigraph.getRegionDigraphPersistence().save(regionDigraph, (OutputStream)output);
            }
            catch (Exception e) {
                throw new DumpContributionFailedException("Failed to dump region digraph", (Throwable)e);
            }
        }
        finally {
            this.bundleContext.ungetService(serviceReference);
        }
    }

    public String getName() {
        return "region digraph";
    }
}

