/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.management;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceStatistics;
import org.eclipse.virgo.kernel.services.concurrent.management.ExecutorServiceExporter;
import org.eclipse.virgo.kernel.services.concurrent.management.StandardExecutorServiceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxExecutorServiceExporter
implements ExecutorServiceExporter {
    private static final String OBJECT_NAME_PATTERN = "%s:type=Executor Service,name=%s";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final Set<ObjectName> exportedExecutorServices = new HashSet<ObjectName>();
    private final String managementDomain;

    public JmxExecutorServiceExporter(String managementDomain) {
        this.managementDomain = managementDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(ExecutorServiceStatistics executorService) {
        try {
            ObjectName name = new ObjectName(String.format(OBJECT_NAME_PATTERN, this.managementDomain, executorService.getPoolName()));
            StandardExecutorServiceInfo info = new StandardExecutorServiceInfo(executorService);
            this.server.registerMBean(info, name);
            Set<ObjectName> set = this.exportedExecutorServices;
            synchronized (set) {
                this.exportedExecutorServices.add(name);
            }
        }
        catch (JMException e) {
            this.logger.warn(String.format("Unable to register executor service %s for management", executorService), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Set<ObjectName> set = this.exportedExecutorServices;
        synchronized (set) {
            for (ObjectName exportedExecutorService : this.exportedExecutorServices) {
                try {
                    this.server.unregisterMBean(exportedExecutorService);
                }
                catch (JMException e) {
                    this.logger.warn(String.format("Unable to unregister executor service %s from management", exportedExecutorService), (Throwable)e);
                }
            }
        }
    }
}

