/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStore;
import org.eclipse.virgo.util.io.PathReference;

final class GenerationalArtifactStore
extends AbstractArtifactStore
implements ArtifactStore {
    private final PathReference baseDirectory;
    private long generation;
    private final String baseName;

    GenerationalArtifactStore(PathReference basePathReference) {
        super(basePathReference);
        this.baseDirectory = basePathReference.getParent();
        this.baseName = basePathReference.getName();
        long recoveredGeneration = GenerationalArtifactStore.recoverLastGeneration(this.baseDirectory);
        this.generation = recoveredGeneration == -1L ? 0L : recoveredGeneration;
        PathReference currentPathReference = GenerationalArtifactStore.getGenerationPath(this.generation, this.baseDirectory, this.baseName);
        if (recoveredGeneration == -1L) {
            currentPathReference.getParent().createDirectory();
            currentPathReference.delete(true);
        }
    }

    private static long recoverLastGeneration(PathReference baseDirectory) {
        long lastGeneration = -1L;
        File file = baseDirectory.toFile();
        String[] children = file.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                try {
                    long childGeneration = Long.parseLong(child);
                    if (childGeneration > lastGeneration) {
                        lastGeneration = childGeneration;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++n2;
            }
        }
        return lastGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathReference getCurrentPath() {
        Object object = this.monitor;
        synchronized (object) {
            return this.getGenerationPath(this.generation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.generation != 0L) {
                this.getSavedPath().delete(true);
            }
            ++this.generation;
            super.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        Object object = this.monitor;
        synchronized (object) {
            super.restore();
            --this.generation;
        }
    }

    @Override
    protected PathReference getSavedPath() {
        return this.getGenerationPath(this.generation - 1L);
    }

    private PathReference getGenerationPath(long generation) {
        return GenerationalArtifactStore.getGenerationPath(generation, this.baseDirectory, this.baseName);
    }

    private static PathReference getGenerationPath(long generation, PathReference baseDirectory, String baseName) {
        return baseDirectory.newChild(Long.toString(generation)).newChild(baseName);
    }
}

