/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomToXMLStreamWriter {
    public void writeToStream(Node dom, XMLStreamWriter xsw) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xsw.writeStartDocument(doc.getXmlEncoding(), doc.getXmlVersion());
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, xsw);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xsw.writeNamespace(attribute.getLocalName(), attribute.getValue());
            } else if (attribute.getPrefix() == null) {
                xsw.writeAttribute(attribute.getName(), attribute.getValue());
            } else {
                xsw.writeAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
            }
        } else if (currentNode.getNodeType() == 3) {
            xsw.writeCharacters(((Text)currentNode).getNodeValue());
        }
        if (dom.getNodeType() == 9) {
            xsw.writeEndDocument();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElement(Element elem, XMLStreamWriter xsw) throws XMLStreamException {
        void var6_10;
        Object next;
        void var6_7;
        if (elem.getPrefix() != null && elem.getPrefix().length() > 0) {
            String namespaceURI = xsw.getNamespaceContext().getNamespaceURI(elem.getPrefix());
            xsw.writeStartElement(elem.getPrefix(), elem.getLocalName(), elem.getNamespaceURI());
            if (!elem.getNamespaceURI().equals(namespaceURI)) {
                xsw.writeNamespace(elem.getPrefix(), elem.getNamespaceURI());
            }
        } else {
            elem.getLocalName();
            elem.getNodeName();
            if (elem.getNamespaceURI() == null || elem.getNamespaceURI().length() == 0) {
                xsw.writeStartElement(elem.getNodeName());
                String defaultNamespace = xsw.getNamespaceContext().getNamespaceURI("");
                if (defaultNamespace != null && defaultNamespace.length() > 0) {
                    xsw.writeDefaultNamespace("");
                }
            } else {
                xsw.writeStartElement("", elem.getLocalName(), elem.getNamespaceURI());
            }
        }
        NodeList childNodes = elem.getChildNodes();
        NamedNodeMap attrs = elem.getAttributes();
        ArrayList<Object> nonNamespaceDeclAttrs = new ArrayList<Object>();
        boolean bl = false;
        while (var6_7 < attrs.getLength()) {
            next = (Attr)attrs.item((int)var6_7);
            if (next.getNodeType() == 2) {
                Object attribute = next;
                if (next.getPrefix() != null && next.getPrefix().equals("xmlns")) {
                    String currentUri = xsw.getNamespaceContext().getNamespaceURI(next.getLocalName());
                    if (currentUri == null || !currentUri.equals(next.getValue())) {
                        xsw.writeNamespace(next.getLocalName(), next.getValue());
                    }
                } else if (!next.getName().equals("xmlns") || !((Boolean)xsw.getProperty("javax.xml.stream.isRepairingNamespaces")).booleanValue()) {
                    nonNamespaceDeclAttrs.add(attribute);
                }
            }
            ++var6_7;
        }
        for (Attr attr : nonNamespaceDeclAttrs) {
            if (attr.getPrefix() == null) {
                xsw.writeAttribute(attr.getName(), attr.getValue());
                continue;
            }
            xsw.writeAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
        }
        boolean bl2 = false;
        while (var6_10 < childNodes.getLength()) {
            next = childNodes.item((int)var6_10);
            if (next.getNodeType() == 3) {
                xsw.writeCharacters(((Text)next).getNodeValue());
            } else if (next.getNodeType() == 4) {
                xsw.writeCData(next.getNodeValue());
            } else if (next.getNodeType() == 8) {
                xsw.writeComment(next.getNodeValue());
            } else if (next.getNodeType() == 1) {
                this.writeElement((Element)next, xsw);
            }
            ++var6_10;
        }
        xsw.writeEndElement();
    }
}

