/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.artifact.plan.PlanReader;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.ConfigInstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifactFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactGraphFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.util.common.DirectedAcyclicGraph;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.BundleContext;

final class PlanInstallArtifactGraphFactory
extends AbstractArtifactGraphFactory {
    private static final String PROVISIONING_PROPERTY_NAME = "org.eclipse.virgo.kernel.provisioning";
    private final BundleContext bundleContext;
    private final ScopeServiceRepository scopeServiceRepository;
    private final ScopeFactory scopeFactory;
    private final EventLogger eventLogger;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final ParPlanInstallArtifactFactory parFactory;

    public PlanInstallArtifactGraphFactory(@NonNull BundleContext bundleContext, @NonNull ScopeServiceRepository scopeServiceRepository, @NonNull ScopeFactory scopeFactory, @NonNull EventLogger eventLogger, @NonNull BundleInstallArtifactGraphFactory bundleInstallArtifactGraphFactory, @NonNull InstallArtifactRefreshHandler refreshHandler, @NonNull ConfigInstallArtifactGraphFactory configInstallArtifactGraphFactory, @NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull DirectedAcyclicGraph<InstallArtifact> dag) {
        super(dag);
        this.bundleContext = bundleContext;
        this.scopeServiceRepository = scopeServiceRepository;
        this.scopeFactory = scopeFactory;
        this.eventLogger = eventLogger;
        this.refreshHandler = refreshHandler;
        this.parFactory = new ParPlanInstallArtifactFactory(eventLogger, bundleContext, bundleInstallArtifactGraphFactory, scopeServiceRepository, scopeFactory, refreshHandler, configInstallArtifactGraphFactory, artifactStorageFactory, artifactIdentityDeterminer, this);
    }

    @Override
    public GraphNode<InstallArtifact> constructInstallArtifactGraph(ArtifactIdentity identity, ArtifactStorage artifactStorage, Map<String, String> deploymentProperties, String repositoryName) throws DeploymentException {
        String type = identity.getType();
        if ("plan".equalsIgnoreCase(type)) {
            return this.createPlanGraph(identity, artifactStorage, this.getPlanDescriptor(artifactStorage), repositoryName, deploymentProperties);
        }
        if ("par".equalsIgnoreCase(type)) {
            return this.createParGraph(identity, artifactStorage, repositoryName);
        }
        return null;
    }

    private GraphNode<InstallArtifact> createParGraph(ArtifactIdentity artifactIdentity, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        ParPlanInstallArtifact parArtifact = this.parFactory.createParPlanInstallArtifact(artifactIdentity, artifactStorage, repositoryName);
        return this.constructAssociatedGraphNode(parArtifact);
    }

    private PlanDescriptor getPlanDescriptor(ArtifactStorage artifactStorage) throws DeploymentException {
        PlanDescriptor planDescriptor;
        InputStream in = null;
        try {
            PlanDescriptor planDescriptor2;
            in = artifactStorage.getArtifactFS().getEntry("").getInputStream();
            planDescriptor = planDescriptor2 = new PlanReader().read(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)in);
        return planDescriptor;
    }

    private GraphNode<InstallArtifact> createPlanGraph(ArtifactIdentity artifactIdentity, ArtifactStorage artifactStorage, PlanDescriptor planDescriptor, String repositoryName, Map<String, String> deploymentProperties) throws DeploymentException {
        PlanDescriptor.Provisioning resultantProvisioning = this.determinePlanProvisioning(planDescriptor, this.getParentProvisioning(deploymentProperties));
        StandardPlanInstallArtifact planInstallArtifact = new StandardPlanInstallArtifact(artifactIdentity, planDescriptor.getAtomic(), planDescriptor.getScoped(), resultantProvisioning, artifactStorage, new StandardArtifactStateMonitor(this.bundleContext), this.scopeServiceRepository, this.scopeFactory, this.eventLogger, this.refreshHandler, repositoryName, planDescriptor.getArtifactSpecifications());
        return this.constructAssociatedGraphNode(planInstallArtifact);
    }

    private PlanDescriptor.Provisioning getParentProvisioning(Map<String, String> deploymentProperties) {
        String provisioningProperty;
        PlanDescriptor.Provisioning parentProvisioning = PlanDescriptor.Provisioning.AUTO;
        if (deploymentProperties != null && (provisioningProperty = deploymentProperties.get(PROVISIONING_PROPERTY_NAME)) != null && (parentProvisioning = PlanDescriptor.Provisioning.valueOf((String)provisioningProperty.toUpperCase(Locale.ENGLISH))) == PlanDescriptor.Provisioning.INHERIT) {
            parentProvisioning = PlanDescriptor.Provisioning.AUTO;
        }
        return parentProvisioning;
    }

    private PlanDescriptor.Provisioning determinePlanProvisioning(PlanDescriptor planDescriptor, PlanDescriptor.Provisioning parentProvisioning) {
        PlanDescriptor.Provisioning planProvisioningSpec = planDescriptor.getProvisioning();
        PlanDescriptor.Provisioning resultantProvisioning = planProvisioningSpec == PlanDescriptor.Provisioning.INHERIT ? parentProvisioning : planProvisioningSpec;
        return resultantProvisioning;
    }
}

