/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.formatting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.shell.internal.formatting.PropertyFormatter;
import org.eclipse.virgo.shell.internal.util.ServiceHolder;
import org.eclipse.virgo.util.common.StringUtils;

public final class ServiceCommandFormatter {
    private static final int MAX_LINE_LENGTH = 80;
    private static final String MULTIPLE_OBJECT_CLASSES_SUFFIX = ", ...";
    private static final String ID = "Id";
    private static final String OBJECT_CLASSES = "Object Class(es)";
    private static final String PROVIDER = "Providing Bundle";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public List<String> formatList(List<ServiceHolder> services) {
        try {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Collections.sort(services, new QuasiLiveServiceComparator());
            int maxIdLength = ID.length();
            int maxProviderLength = PROVIDER.length();
            for (ServiceHolder service : services) {
                int idLength = Long.valueOf(service.getServiceId()).toString().length();
                maxIdLength = idLength > maxIdLength ? idLength : maxIdLength;
                int providerLength = Long.valueOf(service.getProvider().getBundleId()).toString().length();
                int n = maxProviderLength = providerLength > maxProviderLength ? providerLength : maxProviderLength;
            }
            int objectClassWidth = 80 - (2 + maxIdLength + maxProviderLength);
            ArrayList<String> lines = new ArrayList<String>();
            String format = String.format("%%-%ds %%-%ds %%%ds", maxIdLength, objectClassWidth, maxProviderLength);
            lines.add(String.format(format, ID, OBJECT_CLASSES, PROVIDER));
            for (ServiceHolder service : services) {
                Object objectClass = service.getProperties().get("objectClass");
                lines.add(String.format(format, service.getServiceId(), ServiceCommandFormatter.formatObjectClass(objectClass, objectClassWidth), service.getProvider().getBundleId()));
            }
            ArrayList<String> arrayList = lines;
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public List<String> formatExamine(ServiceHolder service) {
        try {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(String.format("Properties:", new Object[0]));
            lines.addAll(this.formatProperties(service.getProperties()));
            QuasiBundle provider = service.getProvider();
            lines.add("");
            lines.add(String.format("Publisher: %s %s [%s]", provider.getSymbolicName(), provider.getVersion().toString(), provider.getBundleId()));
            lines.add("");
            lines.add(String.format("Consumer(s):", new Object[0]));
            List<QuasiBundle> consumers = service.getConsumers();
            if (consumers.size() == 0) {
                lines.add(String.format("    None", new Object[0]));
            } else {
                for (QuasiBundle consumer : consumers) {
                    lines.add(String.format("    %s %s [%s]", consumer.getSymbolicName(), consumer.getVersion().toString(), consumer.getBundleId()));
                }
            }
            ArrayList<String> arrayList = lines;
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return arrayList;
        }
        catch (Throwable throwable) {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static String formatObjectClass(Object objectClass, int maxLength) {
        try {
            String[] objectClasses;
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            StringBuilder sb = new StringBuilder();
            if (objectClass == null) {
                objectClass = new String[]{};
            }
            if ((objectClasses = objectClass instanceof String ? StringUtils.commaDelimitedListToStringArray((String)((String)objectClass)) : (objectClass instanceof Object[] ? objectClass : StringUtils.commaDelimitedListToStringArray((String)objectClass.toString()))).length == 0) {
                sb.append("<none>");
            } else {
                if (objectClasses.length > 1) {
                    maxLength -= MULTIPLE_OBJECT_CLASSES_SUFFIX.length();
                }
                String formattedObjectClass = StringUtils.abbreviateDotSeparatedString((String)objectClasses[0], (int)maxLength);
                sb.append(formattedObjectClass);
                if (objectClasses.length > 1) {
                    sb.append(MULTIPLE_OBJECT_CLASSES_SUFFIX);
                }
            }
            String string = sb.toString();
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return string;
        }
        catch (Throwable throwable) {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private List<String> formatProperties(Map<String, Object> properties) {
        try {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<String> keys = new ArrayList<String>(properties.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                lines.add(String.format("    %s:", key));
                Object value = properties.get(key);
                if (value instanceof Object[]) {
                    List<String> propertyLines = PropertyFormatter.formatPropertyValue(value, 72);
                    for (String propertyLine : propertyLines) {
                        lines.add(String.format("        %s", propertyLine));
                    }
                    continue;
                }
                lines.add(String.format("        %s", value));
            }
            ArrayList<String> arrayList = lines;
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return arrayList;
        }
        catch (Throwable throwable) {
            ServiceCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ServiceCommandFormatter.java", Class.forName("org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatList", "org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter", "java.util.List:", "services:", "", "java.util.List"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatExamine", "org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter", "org.eclipse.virgo.shell.internal.util.ServiceHolder:", "service:", "", "java.util.List"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "formatObjectClass", "org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter", "java.lang.Object:int:", "objectClass:maxLength:", "", "java.lang.String"), 90);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatProperties", "org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter", "java.util.Map:", "properties:", "", "java.util.List"), 122);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter");
    }

    private static class QuasiLiveServiceComparator
    implements Comparator<ServiceHolder> {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private QuasiLiveServiceComparator() {
        }

        @Override
        public int compare(ServiceHolder service1, ServiceHolder service2) {
            try {
                QuasiLiveServiceComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Long id1 = service1.getServiceId();
                Long id2 = service2.getServiceId();
                int n = id1.compareTo(id2);
                QuasiLiveServiceComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return n;
            }
            catch (Throwable throwable) {
                QuasiLiveServiceComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("ServiceCommandFormatter.java", Class.forName("org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter$QuasiLiveServiceComparator"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compare", "org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter$QuasiLiveServiceComparator", "org.eclipse.virgo.shell.internal.util.ServiceHolder:org.eclipse.virgo.shell.internal.util.ServiceHolder:", "service1:service2:", "", "int"), 145);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.shell.internal.formatting.ServiceCommandFormatter$QuasiLiveServiceComparator");
        }
    }
}

