/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.restrictor;

import java.io.IOException;
import java.io.InputStream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.policy.HttpMethodChecker;
import org.jolokia.restrictor.policy.MBeanAccessChecker;
import org.jolokia.restrictor.policy.NetworkChecker;
import org.jolokia.restrictor.policy.RequestTypeChecker;
import org.jolokia.util.HttpMethod;
import org.jolokia.util.RequestType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PolicyRestrictor
implements Restrictor {
    private HttpMethodChecker httpChecker;
    private RequestTypeChecker requestTypeChecker;
    private NetworkChecker networkChecker;
    private MBeanAccessChecker mbeanAccessChecker;

    public PolicyRestrictor(InputStream pInput) {
        Exception exp = null;
        if (pInput == null) {
            throw new SecurityException("No policy file given");
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pInput);
            this.requestTypeChecker = new RequestTypeChecker(doc);
            this.httpChecker = new HttpMethodChecker(doc);
            this.networkChecker = new NetworkChecker(doc);
            this.mbeanAccessChecker = new MBeanAccessChecker(doc);
        }
        catch (SAXException e) {
            exp = e;
        }
        catch (IOException e) {
            exp = e;
        }
        catch (ParserConfigurationException e) {
            exp = e;
        }
        catch (MalformedObjectNameException e) {
            exp = e;
        }
        if (exp != null) {
            throw new SecurityException("Cannot parse policy file: " + exp, exp);
        }
    }

    public boolean isHttpMethodAllowed(HttpMethod method) {
        return this.httpChecker.check(method);
    }

    public boolean isTypeAllowed(RequestType pType) {
        return this.requestTypeChecker.check(pType);
    }

    public boolean isRemoteAccessAllowed(String ... pHostOrAddress) {
        return this.networkChecker.check(pHostOrAddress);
    }

    public boolean isAttributeReadAllowed(ObjectName pName, String pAttribute) {
        return this.check(RequestType.READ, pName, pAttribute);
    }

    public boolean isAttributeWriteAllowed(ObjectName pName, String pAttribute) {
        return this.check(RequestType.WRITE, pName, pAttribute);
    }

    public boolean isOperationAllowed(ObjectName pName, String pOperation) {
        return this.check(RequestType.EXEC, pName, pOperation);
    }

    private boolean check(RequestType pType, ObjectName pName, String pValue) {
        return this.mbeanAccessChecker.check(new MBeanAccessChecker.Arg(this.isTypeAllowed(pType), pType, pName, pValue));
    }
}

