/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.util.Set;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogicDetector
extends AbstractServerDetector {
    @Override
    public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
        String domainConfigMBean = this.getSingleStringAttribute(pMbeanServers, "*:Name=RuntimeService,*", "DomainConfiguration");
        if (domainConfigMBean != null) {
            String version = this.getSingleStringAttribute(pMbeanServers, domainConfigMBean, "ConfigurationVersion");
            return new ServerHandle("Oracle", "weblogic", version, null, null);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServer> servers) {
        try {
            InitialContext ctx = new InitialContext();
            MBeanServer server = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
            if (server != null) {
                servers.add(server);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

