/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openejb.deployer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentLoader;

public class VirgoDeploymentLoader
extends DeploymentLoader {
    private static final String VIRGO_ROOT_APPLICATION_RESERVED_MODULE_ID = "virgoRootApplicationReservedModuleID";
    private final String webContextPath;

    public VirgoDeploymentLoader(String webContextPath) {
        this.webContextPath = webContextPath;
    }

    public AppModule load(File arg0) throws OpenEJBException {
        AppModule result = super.load(arg0);
        result.setModuleId(this.createModuleIDFromWebContextPath());
        return result;
    }

    private String createModuleIDFromWebContextPath() {
        if (this.webContextPath.equals("")) {
            return VIRGO_ROOT_APPLICATION_RESERVED_MODULE_ID;
        }
        return this.webContextPath.substring(1);
    }

    protected String getContextRoot() {
        return this.webContextPath;
    }

    protected Map<String, URL> getWebDescriptors(File warFile) throws IOException {
        TreeMap<String, URL> descriptors;
        block16: {
            descriptors = new TreeMap<String, URL>();
            if (warFile.isFile()) {
                URL jarURL = new URL("jar", "", -1, warFile.toURI().toURL() + "!/");
                JarFile jarFile = null;
                try {
                    try {
                        jarFile = new JarFile(warFile);
                        for (JarEntry entry : Collections.list(jarFile.entries())) {
                            String entryName = entry.getName();
                            if (entry.isDirectory() || !entryName.startsWith("WEB-INF/") || entryName.indexOf(47, "WEB-INF".length()) <= 0) continue;
                            descriptors.put(entryName, new URL(jarURL, entry.getName()));
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException2) {}
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        descriptors.putAll(super.getWebDescriptors(warFile));
        return descriptors;
    }
}

