/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openejb.deployer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.validation.ValidationException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.naming.ContextAccessController;
import org.apache.naming.NamingContext;
import org.apache.openejb.AppContext;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.DeployerEjb;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.AutoConfig;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.ContextUtil;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.web.enterprise.openejb.deployer.DynamicDeployerWithStandardContext;
import org.eclipse.virgo.web.enterprise.openejb.deployer.OpenEjbDeployerDSComponent;
import org.eclipse.virgo.web.enterprise.openejb.deployer.VirgoDeploymentLoader;
import org.eclipse.virgo.web.enterprise.openejb.deployer.VirgoUndeployerEjb;
import org.eclipse.virgo.web.enterprise.openejb.deployer.log.OpenEjbDeployerLogEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless(name="openejb/Deployer")
@Remote(value={Deployer.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class VirgoDeployerEjb
extends DeployerEjb {
    private static final String OPENEJB_SCHEME = "openejb:";
    private static final String JAVA_SCHEME = "java:";
    private static final String TRANSACTION_TYPE_BEAN = "Bean";
    private static final String META_INF = "META-INF";
    private static final String DISABLED_SUFFIX = ".disabled";
    private static final String RESOURCES_XML = "resources.xml";
    private static final String PROVIDER = "provider";
    private static final String TRANSACTION_TYPE_PROP = "transactionType";
    private static final String STANDARD_CONTEXT_PROPERTY = "CatalinaStandardContext";
    private static final String DATA_SOURCE = "DataSource";
    private static final String OPENEJB_JDBC_DRIVER = "JdbcDriver";
    private static final String TOMCAT_DRIVER_CLASS_NAME = "driverClassName";
    private static final String OPENEJB_JDBC_URL = "JdbcUrl";
    private static final String TOMCAT_JDBC_URL = "url";
    private static final String OPENEJB_USERNAME = "UserName";
    private static final String TOMCAT_USERNAME = "username";
    private final DeploymentLoader deploymentLoader;
    private final ConfigurationFactory configurationFactory;
    private final Assembler assembler;
    private List<ServiceProvider> resourceProviders;
    private final String webContextPath;
    private final ClassLoader servletClassLoader;
    private DynamicDeployer dynamicDeployer = null;
    private Logger logger = LoggerFactory.getLogger(VirgoDeployerEjb.class);

    public VirgoDeployerEjb(String webContextPath, ClassLoader servletClassLoader) {
        this.deploymentLoader = new VirgoDeploymentLoader(webContextPath);
        this.dynamicDeployer = OpenEjbDeployerDSComponent.getDynamicDeployer();
        this.configurationFactory = this.dynamicDeployer != null ? new ConfigurationFactory(false, this.dynamicDeployer) : new ConfigurationFactory();
        this.assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);
        this.webContextPath = webContextPath;
        this.servletClassLoader = servletClassLoader;
        try {
            this.resourceProviders = ServiceUtils.getServiceProvidersByServiceType((String)"Resource");
        }
        catch (OpenEJBException openEJBException) {
            this.resourceProviders = new ArrayList<ServiceProvider>(0);
        }
    }

    public AppInfo deploy(String loc, StandardContext standardContext) throws OpenEJBException {
        if (loc == null) {
            throw new NullPointerException("location is null");
        }
        if (this.dynamicDeployer != null && this.dynamicDeployer instanceof DynamicDeployerWithStandardContext) {
            ((DynamicDeployerWithStandardContext)this.dynamicDeployer).setStandardContext(standardContext);
        }
        Properties p = new Properties();
        AppModule appModule = null;
        try {
            File file = new File(loc);
            appModule = this.deploymentLoader.load(file);
            this.addAlternativeDDs(p, appModule);
            this.disableResourcesDescriptors(appModule);
            this.processResources(appModule, standardContext);
            AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
            if (p != null && p.containsKey("openejb.deployer.forced.appId")) {
                appInfo.appId = p.getProperty("openejb.deployer.forced.appId");
            }
            AppContext appContext = this.assembler.createApplication(appInfo);
            this.bindOpenEjbRefsInTomcat(appInfo, appContext, standardContext);
            this.logMessage("Initialised enterprise container for application with context path '" + this.webContextPath + "'.", OpenEjbDeployerLogEvents.DEPLOYED_APP);
            return appInfo;
        }
        catch (Throwable e) {
            this.logMessage("Failed to initialise enterprise container for application with context path '" + this.webContextPath + "'.", OpenEjbDeployerLogEvents.FAILED_TO_DEPLOY_APP);
            if (appModule != null) {
                ClassLoaderUtil.destroyClassLoader((String)appModule.getJarLocation());
            }
            this.logger.error("Error while deploying application with real path '" + loc + "' and web context path '" + this.webContextPath + "'", e);
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e instanceof OpenEJBException) {
                if (e.getCause() instanceof ValidationException) {
                    throw (ValidationException)e.getCause();
                }
                throw (OpenEJBException)e;
            }
            throw new OpenEJBException("Error while deploying application with real path '" + loc + "' and web context path '" + this.webContextPath + "'.", e);
        }
    }

    private String normalize(String rootContext) {
        String result = rootContext.replace("\\", "/");
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    private void bindOpenEjbRefsInTomcat(AppInfo appInfo, AppContext appContext, StandardContext standardContext) throws OpenEJBException, NamingException, IllegalStateException {
        WebAppInfo webAppInfo = this.getWebAppInfo(appInfo);
        JndiEncBuilder jndiBuilder = new JndiEncBuilder(webAppInfo.jndiEnc, null, webAppInfo.moduleId, TRANSACTION_TYPE_BEAN, null, webAppInfo.uniqueId, this.servletClassLoader);
        appContext.getBindings().putAll(jndiBuilder.buildBindings(JndiEncBuilder.JndiScope.comp));
        ContextAccessController.setWritable((Object)standardContext.getNamingContextListener().getName(), (Object)standardContext);
        try {
            NamingContext root = standardContext.getNamingContextListener().getNamingContext();
            this.bindRefInTomcat(appContext.getBindings(), (Context)root);
        }
        finally {
            ContextAccessController.setReadOnly((Object)standardContext.getNamingContextListener().getName());
        }
    }

    private WebAppInfo getWebAppInfo(AppInfo appInfo) {
        for (WebAppInfo w : appInfo.webApps) {
            if (!this.normalize(w.contextRoot).equals(this.webContextPath) && !"".equals(this.webContextPath)) continue;
            return w;
        }
        throw new IllegalStateException("Could not find web app info matching web context path: " + this.webContextPath);
    }

    private void bindRefInTomcat(Map<String, Object> appBindings, Context jndiContext) throws NamingException, IllegalStateException {
        this.logger.debug("Binding OpenEjb naming objects to Tomcat's naming context...");
        for (Map.Entry<String, Object> entry : appBindings.entrySet()) {
            Object value = this.normalizeLinkRef(entry.getValue());
            String jndiName = entry.getKey();
            if (jndiName.contains("comp/BeanManager")) continue;
            this.logger.debug("Binding " + jndiName + " with value " + value);
            ContextUtil.mkdirs((Context)jndiContext, (String)jndiName);
            try {
                jndiContext.bind(jndiName, value);
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {}
        }
    }

    private Object normalizeLinkRef(Object value) {
        RefAddr refAddr;
        String address;
        Object object = value;
        if (value instanceof LinkRef && !(address = (refAddr = ((LinkRef)value).get(0)).getContent().toString()).startsWith(OPENEJB_SCHEME) && !address.startsWith(JAVA_SCHEME)) {
            object = new LinkRef(JAVA_SCHEME + address);
        }
        return object;
    }

    private void addAlternativeDDs(Properties p, AppModule appModule) throws MalformedURLException {
        Map<String, DeploymentModule> modules = this.getAllModules(appModule);
        this.processAlternativeDDs(p, appModule, modules);
    }

    private void processAlternativeDDs(Properties p, AppModule appModule, Map<String, DeploymentModule> modules) throws MalformedURLException {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith("altDD/")) continue;
            name = name.substring("altDD".length() + 1);
            DeploymentModule module = this.getDeploymentModule(name, appModule, modules);
            this.addAltDDtoModule(entry, name, module);
        }
    }

    private void addAltDDtoModule(Map.Entry<Object, Object> entry, String name, DeploymentModule module) throws MalformedURLException {
        if (module != null) {
            String value = (String)entry.getValue();
            File dd = new File(value);
            if (dd.canRead()) {
                module.getAltDDs().put(name, dd.toURI().toURL());
            } else {
                module.getAltDDs().put(name, value);
            }
        }
    }

    private DeploymentModule getDeploymentModule(String name, AppModule appModule, Map<String, DeploymentModule> modules) {
        AppModule module;
        int slash = name.indexOf(47);
        if (slash > 0) {
            String moduleId = name.substring(0, slash);
            name = name.substring(slash + 1);
            module = modules.get(moduleId);
        } else {
            module = appModule;
        }
        return module;
    }

    private Map<String, DeploymentModule> getAllModules(AppModule appModule) {
        TreeMap<String, DeploymentModule> modules = new TreeMap<String, DeploymentModule>();
        for (DeploymentModule module : appModule.getEjbModules()) {
            modules.put(module.getModuleId(), module);
        }
        for (DeploymentModule module : appModule.getClientModules()) {
            modules.put(module.getModuleId(), module);
        }
        for (DeploymentModule module : appModule.getWebModules()) {
            modules.put(module.getModuleId(), module);
        }
        for (DeploymentModule module : appModule.getConnectorModules()) {
            modules.put(module.getModuleId(), module);
        }
        return modules;
    }

    private void disableResourcesDescriptors(AppModule appModule) {
        Map<String, DeploymentModule> modules = this.getAllModules(appModule);
        for (DeploymentModule module : modules.values()) {
            URI resourceXmlURI;
            URL url = this.getResourcesUrl(module);
            if (url == null) continue;
            try {
                resourceXmlURI = url.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            File resourceXmlFile = new File(resourceXmlURI);
            File resourceXmlDisabledFile = new File(String.valueOf(resourceXmlFile.getAbsolutePath()) + DISABLED_SUFFIX);
            resourceXmlFile.renameTo(resourceXmlDisabledFile);
        }
    }

    private URL getResourcesUrl(DeploymentModule module) {
        URL url = (URL)module.getAltDDs().get(RESOURCES_XML);
        if (url == null && module.getClassLoader() != null) {
            url = module.getClassLoader().getResource("META-INF/resources.xml");
        }
        return url;
    }

    public void undeploy(String moduleId) throws UndeployException, NoSuchApplicationException {
        try {
            VirgoUndeployerEjb undeployer = new VirgoUndeployerEjb(moduleId);
            undeployer.undeploy();
            super.undeploy(moduleId);
            undeployer.clearResources(moduleId);
            this.logMessage("Destroyed enterprise container for application with context path '" + this.webContextPath + "'.", OpenEjbDeployerLogEvents.UNDEPLOYED_APP);
        }
        catch (Throwable e) {
            this.logMessage("Failed to destroy enterprise container for application with context path '" + this.webContextPath + "'.", OpenEjbDeployerLogEvents.FAILED_TO_UNDEPLOY_APP);
            throw new UndeployException("Error while undeploying application with module id and web context path '" + this.webContextPath + "'.", e);
        }
    }

    private void logMessage(String message, LogEvent event) {
        if (OpenEjbDeployerDSComponent.getEventLogger() == null) {
            System.out.println(message);
        } else {
            OpenEjbDeployerDSComponent.getEventLogger().log(event, new Object[]{this.webContextPath});
        }
    }

    public void processResources(AppModule appModule, StandardContext standardContext) {
        ContextResource[] contextResources = standardContext.getNamingResources().findResources();
        if (contextResources == null) {
            return;
        }
        ContextResource[] contextResourceArray = contextResources;
        int n = contextResources.length;
        int n2 = 0;
        while (n2 < n) {
            ContextResource contextResource = contextResourceArray[n2];
            if (this.isResourceTypeSupported(contextResource)) {
                Resource resource = this.createResource(contextResource, standardContext, appModule.getModuleId());
                appModule.getResources().add(resource);
            }
            ++n2;
        }
        Collection<String> tomcatResources = this.getResourcesNames(standardContext.getNamingResources());
        AutoConfig.PROVIDED_RESOURCES.set(tomcatResources);
        AutoConfig.PROVIDED_RESOURCES_PREFIX.set("java:/comp/env/");
    }

    private Collection<String> getResourcesNames(NamingResources namingResources) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> tomcatResources = new ArrayList<Object>();
        tomcatResources.addAll(Arrays.asList(namingResources.findResources()));
        tomcatResources.addAll(Arrays.asList(namingResources.findEnvironments()));
        tomcatResources.addAll(Arrays.asList(namingResources.findResourceLinks()));
        tomcatResources.addAll(Arrays.asList(namingResources.findServices()));
        tomcatResources.addAll(Arrays.asList(namingResources.findResourceEnvRefs()));
        for (ResourceBase resourceBase : tomcatResources) {
            String processedResourceName = this.getResourceNameFromTomcatResource(names, resourceBase);
            if (processedResourceName == null) continue;
            names.add(processedResourceName);
        }
        return names;
    }

    private String getResourceNameFromTomcatResource(Collection<String> names, ResourceBase resource) {
        String name = resource.getName();
        String mappedName = (String)resource.getProperty("mappedName");
        String processedResourceName = name;
        if (mappedName != null) {
            processedResourceName = mappedName;
        }
        return processedResourceName;
    }

    private Resource createResource(ContextResource contextResource, StandardContext standardContext, String appModuleId) {
        String id = String.valueOf(appModuleId) + '/' + contextResource.getName();
        String type = contextResource.getType();
        String provider = (String)contextResource.getProperty(PROVIDER);
        Resource resource = new Resource(id, type, provider);
        this.populateResourceProperties(contextResource, resource, standardContext);
        return resource;
    }

    private void populateResourceProperties(ContextResource contextResource, Resource resource, StandardContext standardContext) {
        Properties resProperties = resource.getProperties();
        Iterator ctxResPropertiesItr = contextResource.listProperties();
        boolean isDataSource = contextResource.getType().contains(DATA_SOURCE);
        while (ctxResPropertiesItr.hasNext()) {
            String key = (String)ctxResPropertiesItr.next();
            if (PROVIDER.equals(key) || key.length() == 0) continue;
            Object value = contextResource.getProperty(key);
            if (isDataSource) {
                key = this.transformKey(key);
            }
            resProperties.put(key, value);
        }
        if (isDataSource) {
            resProperties.put(STANDARD_CONTEXT_PROPERTY, standardContext);
        }
    }

    private String transformKey(String key) {
        String transformedKey;
        if (TOMCAT_USERNAME.equals(key)) {
            transformedKey = OPENEJB_USERNAME;
        } else if (TOMCAT_JDBC_URL.equals(key)) {
            transformedKey = OPENEJB_JDBC_URL;
        } else if (TOMCAT_DRIVER_CLASS_NAME.equals(key)) {
            transformedKey = OPENEJB_JDBC_DRIVER;
        } else if (TRANSACTION_TYPE_PROP.equals(key)) {
            transformedKey = TRANSACTION_TYPE_PROP;
        } else {
            StringBuffer buffer = new StringBuffer(key);
            buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
            transformedKey = buffer.toString();
        }
        return transformedKey;
    }

    private boolean isResourceTypeSupported(ContextResource contextResource) {
        String resourceType = contextResource.getType();
        for (ServiceProvider serviceProvider : this.resourceProviders) {
            if (!serviceProvider.getTypes().contains(resourceType)) continue;
            return true;
        }
        String provider = (String)contextResource.getProperty(PROVIDER);
        if (provider == null) {
            return false;
        }
        try {
            ServiceProvider serviceProvider = ServiceUtils.getServiceProvider((String)provider);
            return serviceProvider.getTypes().contains(resourceType);
        }
        catch (OpenEJBException openEJBException) {
            return false;
        }
    }
}

