/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.bundle;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.DependencyDeterminer;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public final class BundleDependencyDeterminer
implements DependencyDeterminer {
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private final RuntimeArtifactRepository artifactRepository;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public BundleDependencyDeterminer(@NonNull QuasiFrameworkFactory quasiFrameworkFactory, @NonNull RuntimeArtifactRepository artifactRepository, @NonNull RegionDigraph regionDigraph) {
        RegionDigraph regionDigraph2 = regionDigraph;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        QuasiFrameworkFactory quasiFrameworkFactory2 = quasiFrameworkFactory;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)quasiFrameworkFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)regionDigraph2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.quasiFrameworkFactory = quasiFrameworkFactory;
            this.artifactRepository = artifactRepository;
            this.regionDigraph = regionDigraph;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Set<Artifact> getDependents(Artifact rootArtifact) {
        try {
            if (!rootArtifact.getType().equalsIgnoreCase("bundle")) {
                return Collections.emptySet();
            }
            QuasiBundle rootBundle = this.getBundle(rootArtifact);
            if (rootBundle == null) {
                return Collections.emptySet();
            }
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (QuasiImportPackage importPackage : rootBundle.getImportPackages()) {
                QuasiExportPackage provider = importPackage.getProvider();
                if (provider == null) continue;
                QuasiBundle bundle = provider.getExportingBundle();
                Artifact artifact = this.artifactRepository.getArtifact("bundle", bundle.getSymbolicName(), bundle.getVersion(), this.regionDigraph.getRegion(bundle.getBundleId()));
                artifacts.add(artifact);
            }
            return artifacts;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private QuasiBundle getBundle(Artifact artifact) {
        try {
            QuasiFramework framework = this.quasiFrameworkFactory.create();
            for (QuasiBundle bundle : framework.getBundles()) {
                if (!artifact.getName().equals(bundle.getSymbolicName()) || !artifact.getVersion().equals((Object)bundle.getVersion()) || !artifact.getRegion().getName().equals(this.regionDigraph.getRegion(bundle.getBundleId()).getName())) continue;
                return bundle;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.bundle.BundleDependencyDeterminer");
    }
}

