/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.recovery;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentOptions;
import org.eclipse.virgo.kernel.deployer.core.FatalDeploymentException;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.PathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeployerRecoveryLog {
    private static final String REDEPLOY_FILE_NAME = "deployed";
    private static final String REDEPLOY_COMPRESSION_FILE_NAME = "deployed.compress";
    private static final int INITIAL_REDEPLOY_DATA_SIZE = 32768;
    private static final int COMPRESSION_THRESHOLD = 10;
    private static final int COMMAND_LENGTH = 3;
    private static final String UNDEPLOY_URI_COMMAND = "---";
    private static final String URI_SEPARATOR = ";";
    private final Logger logger;
    private final PathReference redeployDataset;
    private final PathReference redeployCompressionDataset;
    private final long redeployFileLastModified;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    DeployerRecoveryLog(PathReference workArea) {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            PathReference recoveryArea = workArea.newChild("recovery");
            recoveryArea.createDirectory();
            this.redeployDataset = recoveryArea.newChild(REDEPLOY_FILE_NAME);
            this.redeployFileLastModified = this.redeployDataset.toFile().lastModified();
            this.redeployCompressionDataset = recoveryArea.newChild(REDEPLOY_COMPRESSION_FILE_NAME);
            if (!this.redeployDataset.exists() && this.redeployCompressionDataset.exists()) {
                this.redeployCompressionDataset.copy(this.redeployDataset);
                if (!this.redeployCompressionDataset.delete()) {
                    this.logger.warn("Could not delete '%s' in recovery after compression failure.", (Object)this.redeployCompressionDataset);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public Map<URI, DeploymentOptions> getRecoveryState() {
        try {
            LinkedHashMap<URI, DeploymentOptions> redeploySet = new LinkedHashMap<URI, DeploymentOptions>(20);
            String redeployData = this.readRedployData();
            int recordCount = 0;
            int undeployCount = 0;
            String[] stringArray = redeployData.split(URI_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uriCommandString = stringArray[n2];
                ++recordCount;
                if (uriCommandString.length() >= 3) {
                    String uriCommand = uriCommandString.substring(0, 3);
                    String uriString = uriCommandString.substring(3);
                    try {
                        URI uri = new URI(uriString);
                        if (UNDEPLOY_URI_COMMAND.equals(uriCommand)) {
                            ++undeployCount;
                            redeploySet.remove(uri);
                        } else {
                            char[] commands = uriCommand.toCharArray();
                            DeploymentOptions options = new DeploymentOptions(DeployerRecoveryLog.fromCommandOption(commands[0]), DeployerRecoveryLog.fromCommandOption(commands[1]), DeployerRecoveryLog.fromCommandOption(commands[2]));
                            redeploySet.put(uri, options);
                        }
                    }
                    catch (URISyntaxException e) {
                        this.logger.error("Invalid URI in command string '%s' read from redeploy dataset", (Object)e, (Object)uriCommandString);
                    }
                }
                ++n2;
            }
            if (10 * undeployCount > recordCount) {
                this.rewriteRedeploySet(redeploySet);
            }
            return redeploySet;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String readRedployData() {
        try {
            try {
                StringBuffer redeployData;
                block18: {
                    DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                    redeployData = new StringBuffer(32768);
                    try {
                        BufferedReader redeployDataReader = new BufferedReader(new FileReader(this.redeployDataset.toFile()));
                        try {
                            try {
                                int numRead;
                                char[] chars = new char[32768];
                                while (-1 != (numRead = redeployDataReader.read(chars))) {
                                    redeployData.append(String.valueOf(chars, 0, numRead));
                                }
                            }
                            catch (IOException e) {
                                this.logger.error("Problem reading redeploy dataset", (Throwable)e);
                                try {
                                    ((Reader)redeployDataReader).close();
                                }
                                catch (IOException e2) {
                                    this.logger.error("Problem closing redeploy dataset", (Throwable)e2);
                                }
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ((Reader)redeployDataReader).close();
                            }
                            catch (IOException e) {
                                this.logger.error("Problem closing redeploy dataset", (Throwable)e);
                            }
                            throw throwable;
                        }
                        try {
                            ((Reader)redeployDataReader).close();
                        }
                        catch (IOException e) {
                            this.logger.error("Problem closing redeploy dataset", (Throwable)e);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                String string = redeployData.toString();
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return string;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void rewriteRedeploySet(Map<URI, DeploymentOptions> redeploySet) {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                this.redeployCompressionDataset.delete();
                try {
                    BufferedWriter redeployDataWriter = new BufferedWriter(new FileWriter(this.redeployCompressionDataset.toFile()));
                    for (Map.Entry<URI, DeploymentOptions> redeployEntry : redeploySet.entrySet()) {
                        DeployerRecoveryLog.recordUriCommand(redeployDataWriter, redeployEntry.getKey(), this.getCommandString(redeployEntry.getValue()));
                    }
                    ((Writer)redeployDataWriter).close();
                }
                catch (IOException e) {
                    this.logger.warn("Problem while rewriting redeploy dataset", (Throwable)e);
                }
                this.redeployDataset.delete();
                this.redeployCompressionDataset.moveTo(this.redeployDataset);
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void add(URI location, DeploymentOptions deploymentOptions) {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                this.recordUriCommand(location, this.getCommandString(deploymentOptions));
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getCommandString(DeploymentOptions deploymentOptions) {
        try {
            StringBuilder command = new StringBuilder().append(DeployerRecoveryLog.toCommandOption(deploymentOptions.getRecoverable())).append(DeployerRecoveryLog.toCommandOption(deploymentOptions.getDeployerOwned())).append(DeployerRecoveryLog.toCommandOption(deploymentOptions.getSynchronous()));
            return command.toString();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void remove(URI location) {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                this.recordUriCommand(location, UNDEPLOY_URI_COMMAND);
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void recordUriCommand(URI uri, String command) {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                try {
                    FileWriter writer = new FileWriter(this.redeployDataset.toFile(), true);
                    DeployerRecoveryLog.recordUriCommand(writer, uri, command);
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    throw new FatalDeploymentException("Failed to record (un)deployment", (Throwable)e);
                }
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static void recordUriCommand(Writer writer, URI uri, String command) throws IOException {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                writer.write(command);
                writer.write(uri.toString());
                writer.write(URI_SEPARATOR);
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static char toCommandOption(boolean deploymentOption) {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                char c = deploymentOption ? (char)'Y' : 'N';
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return c;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean fromCommandOption(char commandOption) {
        try {
            try {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                boolean bl = 'Y' == commandOption;
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return bl;
            }
            catch (Throwable throwable) {
                DeployerRecoveryLog.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public long getRedeployFileLastModified() {
        try {
            return this.redeployFileLastModified;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public boolean setRedeployFileLastModified() {
        try {
            return this.redeployDataset.touch();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("DeployerRecoveryLog.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readRedployData", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "", "", "", "java.lang.String"), 134);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "rewriteRedeploySet", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "java.util.Map:", "redeploySet:", "", "void"), 167);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "add", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "location:deploymentOptions:", "", "void"), 191);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "remove", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "java.net.URI:", "location:", "", "void"), 213);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "recordUriCommand", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "java.net.URI:java.lang.String:", "uri:command:", "", "void"), 219);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "recordUriCommand", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "java.io.Writer:java.net.URI:java.lang.String:", "writer:uri:command:", "java.io.IOException:", "void"), 229);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "toCommandOption", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "boolean:", "deploymentOption:", "", "char"), 241);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "fromCommandOption", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog", "char:", "commandOption:", "", "boolean"), 251);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog");
    }
}

