/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.deployer.config.ConfigurationDeployer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshException;
import org.eclipse.virgo.kernel.install.artifact.internal.StartEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StartException;
import org.eclipse.virgo.kernel.install.artifact.internal.StopEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StopException;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLifecycleEngine
implements StartEngine,
RefreshEngine,
StopEngine {
    private final Logger logger;
    private BundleContext context;
    private ConfigurationDeployer configurationDeployer;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ConfigLifecycleEngine(BundleContext context) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.context = context;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void start(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws StartException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                this.initialiseConfigurationDeployer();
                try {
                    this.updateConfiguration(artifactIdentity, artifactFS);
                }
                catch (IOException e) {
                    String message = String.format("Unable to start configuration '%s' with '%s'", artifactIdentity.getName(), artifactFS);
                    this.logger.error(message);
                    throw new StartException(message, e);
                }
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void initialiseConfigurationDeployer() {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                ServiceReference configurationImporterRef = this.context.getServiceReference(ConfigurationDeployer.class);
                this.configurationDeployer = (ConfigurationDeployer)this.context.getService(configurationImporterRef);
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void refresh(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws RefreshException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                try {
                    this.updateConfiguration(artifactIdentity, artifactFS);
                }
                catch (IOException e) {
                    String message = String.format("Unable to refresh configuration '%s' with '%s'", artifactIdentity.getName(), artifactFS);
                    this.logger.error(message);
                    throw new RefreshException(message, e);
                }
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void updateConfiguration(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws IOException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                InputStream inputStream = null;
                try {
                    inputStream = artifactFS.getEntry("").getInputStream();
                    this.configurationDeployer.publishConfiguration(artifactIdentity.getName(), this.getProperties(inputStream));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)inputStream);
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties getProperties(InputStream inputSteam) throws IOException {
        try {
            Properties p = new Properties();
            p.load(inputSteam);
            return p;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void stop(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws StopException {
        try {
            try {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
                try {
                    this.configurationDeployer.deleteConfiguration(artifactIdentity.getName());
                }
                catch (IOException e) {
                    String message = String.format("Unable to stop configuration '%s'", artifactIdentity.getName());
                    this.logger.error(message);
                    throw new StopException(message, e);
                }
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                ConfigLifecycleEngine.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("ConfigLifecycleEngine.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "org.eclipse.virgo.kernel.install.artifact.internal.StartException:", "void"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initialiseConfigurationDeployer", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "", "", "", "void"), 53);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "org.eclipse.virgo.kernel.install.artifact.internal.RefreshException:", "void"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateConfiguration", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "java.io.IOException:", "void"), 68);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactIdentity:artifactFS:", "org.eclipse.virgo.kernel.install.artifact.internal.StopException:", "void"), 85);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.ConfigLifecycleEngine");
    }
}

