/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.impl.config;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.virgo.medic.log.ConfigurationPublicationFailedException;
import org.eclipse.virgo.medic.log.LoggingConfiguration;
import org.eclipse.virgo.medic.log.LoggingConfigurationPublisher;
import org.eclipse.virgo.medic.log.impl.config.StandardLoggingConfiguration;
import org.osgi.framework.BundleContext;

public class StandardLoggingConfigurationPublisher
implements LoggingConfigurationPublisher {
    private final BundleContext context;
    private static final String DEFAULT_CONFIGURATION_ID = "org.eclipse.virgo.medic";

    public StandardLoggingConfigurationPublisher(BundleContext context) {
        this.context = context;
    }

    public void publishConfiguration(File configuration, String id) throws ConfigurationPublicationFailedException {
        LoggingConfiguration loggingConfiguration = StandardLoggingConfigurationPublisher.createLoggingConfiguration(configuration, id);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("org.eclipse.virgo.medic.log.configuration.id", id);
        this.context.registerService(LoggingConfiguration.class.getName(), (Object)loggingConfiguration, properties);
    }

    private static LoggingConfiguration createLoggingConfiguration(File configuration, String id) throws ConfigurationPublicationFailedException {
        try {
            return new StandardLoggingConfiguration(configuration, id);
        }
        catch (IOException ioe) {
            throw new ConfigurationPublicationFailedException("Failed to read the configuration from the file '" + configuration.getAbsolutePath() + "'.", (Throwable)ioe);
        }
    }

    public void publishDefaultConfiguration(File file) throws ConfigurationPublicationFailedException {
        this.publishConfiguration(file, DEFAULT_CONFIGURATION_ID);
    }
}

