/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.configuration;

import java.io.File;
import java.util.Set;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.UriMapper;
import org.eclipse.virgo.repository.configuration.PersistentRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.IdentityUriMapper;

public class WatchedStorageRepositoryConfiguration
extends PersistentRepositoryConfiguration {
    private final File directoryToWatch;
    private final int watchInterval;

    public WatchedStorageRepositoryConfiguration(String name, File indexLocation, Set<ArtifactBridge> artifactBridges, String directoryToWatch, int watchInterval, String mBeanDomain) {
        this(name, indexLocation, artifactBridges, directoryToWatch, watchInterval, new IdentityUriMapper(), mBeanDomain);
    }

    public WatchedStorageRepositoryConfiguration(String name, File indexLocation, Set<ArtifactBridge> artifactBridges, String directoryToWatch, int watchInterval, UriMapper uriMapper, String mBeanDomain) {
        super(name, indexLocation, artifactBridges, uriMapper, mBeanDomain);
        this.directoryToWatch = this.validateWatchDirectory(directoryToWatch);
        if (watchInterval <= 0) {
            throw new IllegalArgumentException("watch interval (" + watchInterval + ") must be 1 or more seconds");
        }
        this.watchInterval = watchInterval;
    }

    private File validateWatchDirectory(String watchDirPath) {
        if (watchDirPath == null) {
            throw new IllegalArgumentException("watch directory path must not be null");
        }
        try {
            File wdFile = new File(watchDirPath);
            if (!wdFile.exists()) {
                return wdFile;
            }
            if (wdFile.isDirectory()) {
                return wdFile;
            }
        }
        catch (Exception exception) {}
        throw new IllegalArgumentException("watch directory path '" + watchDirPath + "' is not a valid directory path");
    }

    public File getDirectoryToWatch() {
        return this.directoryToWatch;
    }

    public int getWatchInterval() {
        return this.watchInterval;
    }
}

