/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.facet.core.BundleFacetInstallDataModelProvider;
import org.eclipse.virgo.ide.facet.core.FacetCorePlugin;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.eclipse.virgo.ide.ui.wizards.AbstractPropertiesPage;
import org.eclipse.virgo.ide.ui.wizards.Messages;
import org.eclipse.virgo.ide.ui.wizards.NewBundleInformationPage;
import org.eclipse.virgo.ide.ui.wizards.NewBundleProjectCreationPage;
import org.eclipse.virgo.ide.ui.wizards.NewBundleProjectSettingsPage;
import org.eclipse.virgo.ide.ui.wizards.NullPropertiesPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBundleProjectWizard
extends NewElementWizard
implements INewWizard {
    private NewJavaProjectWizardPageOne projectPage;
    private NewBundleInformationPage bundlePage;
    private AbstractPropertiesPage propertiesPage;
    private NewJavaProjectWizardPageTwo finalPage;
    private IProjectProvider projectProvider;
    private final AbstractFieldData bundleData;
    private final IDataModel model;
    private final String title = Messages.NewBundleProjectWizard_title;
    private Map<String, String> properties;
    private String platformModule;

    public NewBundleProjectWizard() {
        this.setWindowTitle(this.title);
        this.setDefaultPageImageDescriptor(ServerIdeUiPlugin.getImageDescriptor("full/wizban/wizban-bundle.png"));
        this.setNeedsProgressMonitor(true);
        this.bundleData = new PluginFieldData();
        this.model = DataModelFactory.createDataModel((IDataModelProvider)new BundleFacetInstallDataModelProvider());
    }

    private void addFacetsToProject(final IJavaProject project) {
        WorkspaceModifyOperation oper = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project.getProject(), (boolean)true, (IProgressMonitor)monitor);
                if (NewBundleProjectWizard.this.model.getBooleanProperty("org.eclipse.virgo.ide.facet.core.ENABLE_WEB_BUNDLE")) {
                    fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.java").getDefaultVersion(), null, monitor);
                    fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5"), null, monitor);
                    NewBundleProjectWizard.this.removeFromClasspath(project, "org.eclipse.jst.j2ee.internal.web.container", monitor);
                    NewBundleProjectWizard.this.removeFromClasspath(project, "org.eclipse.jst.j2ee.internal.module.container", monitor);
                }
                fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.bundle").getDefaultVersion(), null, monitor);
                IRuntime runtime = (IRuntime)NewBundleProjectWizard.this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                if (runtime != null && runtime.supports(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.bundle").getDefaultVersion())) {
                    fProject.setTargetedRuntimes(Collections.singleton(runtime), monitor);
                }
                if (NewBundleProjectWizard.this.model.getBooleanProperty("org.eclipse.virgo.ide.facet.core.ENABLE_BUNDLE_CLASSPATH_CONTAINER")) {
                    NewBundleProjectWizard.this.addToClasspath(project, JavaCore.newContainerEntry((IPath)FacetCorePlugin.CLASSPATH_CONTAINER_PATH), monitor);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)oper);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Failure opening project facets.", (Throwable)e));
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.virgo.ide.ui", "Interruption while opening project facets.", (Throwable)e));
        }
    }

    protected void removeFromClasspath(IJavaProject javaProject, String entryPath, IProgressMonitor monitor) throws CoreException {
        ArrayList<IClasspathEntry> rawClasspath = new ArrayList<IClasspathEntry>();
        rawClasspath.addAll(Arrays.asList(javaProject.getRawClasspath()));
        Iterator iter = rawClasspath.iterator();
        while (iter.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iter.next();
            if (entry.getPath() == null || entry.getPath().toString() == null || !entry.getPath().toString().equals(entryPath)) continue;
            iter.remove();
        }
        javaProject.setRawClasspath(rawClasspath.toArray(new IClasspathEntry[0]), monitor);
    }

    protected void addToClasspath(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] current = javaProject.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = entry;
        javaProject.setRawClasspath(updated, monitor);
    }

    public void addPages() {
        this.projectPage = new NewBundleProjectSettingsPage();
        this.addPage((IWizardPage)this.projectPage);
        this.projectProvider = new IProjectProvider(){

            public IPath getLocationPath() {
                return this.getProject().getLocation();
            }

            public IProject getProject() {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
            }

            public String getProjectName() {
                return NewBundleProjectWizard.this.projectPage.getProjectName();
            }
        };
        this.bundlePage = new NewBundleInformationPage(this.title, this.projectProvider, this.bundleData, this.model);
        this.addPage((IWizardPage)this.bundlePage);
        this.setPropertiesPage(new NullPropertiesPage());
        this.finalPage = new NewBundleProjectCreationPage(this.projectPage);
        this.addPage((IWizardPage)this.finalPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return super.canFinish() && page != this.projectPage;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.finalPage.performFinish(monitor);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    public IJavaElement getCreatedElement() {
        return this.finalPage.getJavaProject();
    }

    public boolean performCancel() {
        this.finalPage.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            this.bundlePage.performPageFinish();
            this.properties = this.propertiesPage.getProperties();
            this.platformModule = this.propertiesPage.getModuleType();
            final IJavaElement element = this.getCreatedElement();
            IJavaProject project = element.getJavaProject();
            this.addFacetsToProject(project);
            this.writeBundleData(project, this.platformModule, this.properties);
            IWorkingSet[] workingSets = this.projectPage.getWorkingSets();
            if (workingSets.length > 0) {
                this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)element, workingSets);
            }
            this.selectAndReveal((IResource)project.getProject());
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPart activePart = NewBundleProjectWizard.this.getActivePart();
                    if (activePart instanceof PackageExplorerPart) {
                        ((PackageExplorerPart)activePart).tryToReveal((Object)element);
                    }
                }
            });
            IFile manifestFile = (IFile)project.getProject().findMember("src/META-INF/MANIFEST.MF");
            if (manifestFile != null) {
                IWorkbenchWindow workbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(manifestFile), BundleManifestEditor.ID_EDITOR);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Error opening editor", (String)e.getMessage());
                }
            }
        }
        return res;
    }

    private void writeBundleData(final IJavaProject project, final String platformModule, final Map<String, String> properties) {
        WorkspaceModifyOperation oper = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                BundleManifestUtils.createNewBundleManifest((IJavaProject)project, (String)NewBundleProjectWizard.this.bundleData.getId(), (String)NewBundleProjectWizard.this.bundleData.getVersion(), (String)NewBundleProjectWizard.this.bundleData.getProvider(), (String)NewBundleProjectWizard.this.bundleData.getName(), (String)platformModule, (Map)properties);
                project.getProject().refreshLocal(2, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)oper);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void setPropertiesPage(AbstractPropertiesPage page) {
        this.propertiesPage = page;
        if (this.getPage(page.getName()) == null) {
            this.addPage((IWizardPage)page);
        }
    }

    protected AbstractPropertiesPage getPropertiesPage() {
        return this.propertiesPage;
    }

    protected NewBundleInformationPage getInformationPage() {
        return this.bundlePage;
    }

    protected NewJavaProjectWizardPageTwo getFinalPage() {
        return this.finalPage;
    }
}

