/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.IPDEColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.virgo.ide.ui.editors.text.ISpringColorConstants;

public class BundleColorManager
implements IColorManager,
IPDEColorConstants,
ISpringColorConstants {
    private static BundleColorManager fColorManager;
    private final Map fColorTable = new HashMap(5);
    private static int counter;

    static {
        counter = 0;
    }

    public BundleColorManager() {
        this.initialize();
    }

    public static IColorManager getDefault() {
        if (fColorManager == null) {
            fColorManager = new BundleColorManager();
        }
        ++counter;
        return fColorManager;
    }

    public static void initializeDefaults(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.default", (RGB)DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.instr", (RGB)PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.string", (RGB)STRING);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.tag", (RGB)TAG);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.xml_comment", (RGB)XML_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_key", (RGB)HEADER_KEY);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_osgi", (RGB)HEADER_OSGI);
        store.setDefault("editor.color.header_osgi_bold", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_value", (RGB)HEADER_VALUE);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_attributes", (RGB)HEADER_ATTRIBUTES);
        store.setDefault("editor.color.header_attributes_italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_assignment", (RGB)HEADER_ASSIGNMENT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_spring", (RGB)HEADER_SPRING);
        store.setDefault("editor.color.header_spring_bold", true);
    }

    private void initialize() {
        IPreferenceStore pstore = PDEPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, "editor.color.default");
        this.putColor(pstore, "editor.color.instr");
        this.putColor(pstore, "editor.color.string");
        this.putColor(pstore, "editor.color.tag");
        this.putColor(pstore, "editor.color.xml_comment");
        this.putColor(pstore, "editor.color.header_key");
        this.putColor(pstore, "editor.color.header_osgi");
        this.putColor(pstore, "editor.color.header_value");
        this.putColor(pstore, "editor.color.header_attributes");
        this.putColor(pstore, "editor.color.header_assignment");
        this.putColor(pstore, "editor.color.header_spring");
        pstore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        String[] stringArray = IColorManager.PROPERTIES_COLORS;
        int n = IColorManager.PROPERTIES_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.putColor(pstore, element);
            ++n2;
        }
    }

    public void disposeColors(boolean resetSingleton) {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
        if (resetSingleton) {
            fColorManager = null;
        }
    }

    public void dispose() {
        if (--counter == 0) {
            this.disposeColors(true);
        }
    }

    private void putColor(IPreferenceStore pstore, String property) {
        this.putColor(property, PreferenceConverter.getColor((IPreferenceStore)pstore, (String)property));
    }

    private void putColor(String property, RGB setting) {
        Color oldColor = (Color)this.fColorTable.get(property);
        if (oldColor != null) {
            if (oldColor.getRGB().equals((Object)setting)) {
                return;
            }
            oldColor.dispose();
        }
        this.fColorTable.put(property, new Color((Device)Display.getCurrent(), setting));
    }

    public Color getColor(String key) {
        Color color = (Color)this.fColorTable.get(key);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Object color = event.getNewValue();
        if (color instanceof RGB) {
            this.putColor(event.getProperty(), (RGB)color);
        } else {
            this.putColor(event.getProperty(), StringConverter.asRGB((String)color.toString()));
        }
    }
}

