/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.virgo.ide.runtime.internal.ui.actions.OpenServerProjectFileAction;

public class RuntimeActionProvider
extends CommonActionProvider {
    private OpenServerProjectFileAction openFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openFileAction = new OpenServerProjectFileAction(this.viewSite.getPage());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openFileAction.selectionChanged(selection);
        if (this.openFileAction.isEnabled()) {
            aMenu.insertAfter("group.open", (IAction)this.openFileAction);
        }
        this.addOpenWithMenu(aMenu);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.openFileAction.selectionChanged(selection);
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
        }
    }

    private void addOpenWithMenu(IMenuManager aMenu) {
        IStructuredSelection ss = (IStructuredSelection)this.getContext().getSelection();
        if (ss == null || ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        Platform.getAdapterManager().getAdapter(o, IResource.class);
        IAdaptable openable = (IAdaptable)RuntimeActionProvider.getAdapter(o, IResource.class);
        if (openable == null) {
            openable = (IAdaptable)RuntimeActionProvider.getAdapter(o, ResourceMapping.class);
        } else if (((IResource)openable).getType() != 1) {
            openable = null;
        }
        if (openable != null) {
            MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.OpenActionProvider_OpenWithMenu_label, "group.openWith");
            submenu.add((IContributionItem)new GroupMarker("group.top"));
            submenu.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), openable));
            submenu.add((IContributionItem)new GroupMarker("additions"));
            if (submenu.getItems().length > 2 && submenu.isEnabled()) {
                aMenu.appendToGroup("group.openWith", (IContributionItem)submenu);
            }
        }
    }

    public static Object getAdapter(Object anElement, Class anAdapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)anAdapterType);
        if (anElement == null) {
            return null;
        }
        if (anAdapterType.isInstance(anElement)) {
            return anElement;
        }
        if (anElement instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)anElement).getAdapter(anAdapterType)) != null) {
            Assert.isTrue((boolean)anAdapterType.isInstance(result2));
            return result2;
        }
        if (!(anElement instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(anElement, anAdapterType)) != null) {
            return result;
        }
        return null;
    }
}

