/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ProjectFileReference;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFile;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.ServerFileSelection;

public class OpenServerProjectFileAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.OpenFileAction";
    private final IWorkbenchPage workbenchPage2;

    public OpenServerProjectFileAction(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenServerProjectFileAction(IWorkbenchPage page, IEditorDescriptor descriptor) {
        super("Open Linked File");
        this.workbenchPage2 = page;
        this.setText(descriptor == null ? IDEWorkbenchMessages.OpenFileAction_text : descriptor.getLabel());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_file_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenFileAction_toolTip);
        this.setId(ID);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object element = ((StructuredSelection)selection).getFirstElement();
        return selection instanceof StructuredSelection && (element instanceof ProjectFileReference || element instanceof IFile || element instanceof ServerFile);
    }

    public void run() {
        for (Object next : this.getStructuredSelection()) {
            if (next instanceof ProjectFileReference) {
                this.openFile(((ProjectFileReference)next).getWorkspaceFile());
                continue;
            }
            if (next instanceof IFile) {
                this.openFile((IFile)next);
                continue;
            }
            if (next instanceof ServerFileSelection) {
                this.openFile((ServerFileSelection)next);
                continue;
            }
            if (!(next instanceof ServerFile)) continue;
            this.openFile(((ServerFile)next).getFile());
        }
    }

    public void openFile(ServerFileSelection selection) {
        IEditorPart openEditor = this.openFile(selection.getFile());
        if (openEditor instanceof ITextEditor) {
            ((ITextEditor)openEditor).selectAndReveal(selection.getOffset(), selection.getLength());
        }
    }

    public IEditorPart openFile(IFile file) {
        try {
            IEditorDescriptor defaultEditor = this.workbenchPage2.getWorkbenchWindow().getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            if (defaultEditor == null) {
                defaultEditor = this.workbenchPage2.getWorkbenchWindow().getWorkbench().getEditorRegistry().getDefaultEditor("fake.txt");
            }
            if (defaultEditor != null) {
                IEditorPart openEditor = this.workbenchPage2.openEditor((IEditorInput)new FileEditorInput(file), defaultEditor.getId());
                return openEditor;
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)this.workbenchPage2.getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenSystemEditorAction_dialogTitle, (String)e.getMessage(), (PartInitException)e);
        }
        return null;
    }
}

