/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.repository;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.runtime.core.ServerCorePlugin;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.wst.server.core.IRuntime;

public class RefreshBundleJob
implements IRunnableWithProgress {
    private final IRuntime runtime;

    RefreshBundleJob(IRuntime runtime) {
        this.runtime = runtime;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.subTask(Messages.RepositoryBrowserEditorPage_RefreshingBundlesMessage);
        if (RepositoryUtils.doesRuntimeSupportRepositories((IRuntime)this.runtime)) {
            ServerCorePlugin.getArtefactRepositoryManager().refreshBundleRepository(this.runtime);
        }
        monitor.done();
    }

    public static void execute(Shell shell, IRuntime runtime) {
        RefreshBundleJob job = new RefreshBundleJob(runtime);
        try {
            ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
            context.run(true, true, (IRunnableWithProgress)job);
        }
        catch (InvocationTargetException e1) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.runtime.core", "\ufffdproblem occurred while updating repository", (Throwable)e1));
        }
        catch (InterruptedException interruptedException) {}
    }
}

