/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.manifest.internal.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestChangeListener;
import org.eclipse.virgo.ide.manifest.core.IBundleManifestMangerWorkingCopy;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestDiffer;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManifestManager
implements IBundleManifestMangerWorkingCopy {
    public static final Set<IBundleManifestChangeListener.Type> IMPORTS_CHANGED = new HashSet<IBundleManifestChangeListener.Type>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock r = this.rwl.readLock();
    private Map<IJavaProject, BundleManifest> bundles = new ConcurrentHashMap<IJavaProject, BundleManifest>();
    private Map<IJavaProject, BundleManifest> testBundles = new ConcurrentHashMap<IJavaProject, BundleManifest>();
    private Map<IJavaProject, Set<String>> packageImports = new ConcurrentHashMap<IJavaProject, Set<String>>();
    private List<IBundleManifestChangeListener> bundleManifestChangeListeners = new CopyOnWriteArrayList<IBundleManifestChangeListener>();
    private Map<IJavaProject, Long> bundleTimestamps = new ConcurrentHashMap<IJavaProject, Long>();
    private Map<IJavaProject, Long> testBundleTimestamps = new ConcurrentHashMap<IJavaProject, Long>();
    private IResourceChangeListener resourceChangeListener = null;

    static {
        IMPORTS_CHANGED.add(IBundleManifestChangeListener.Type.IMPORT_PACKAGE);
        IMPORTS_CHANGED.add(IBundleManifestChangeListener.Type.IMPORT_BUNDLE);
        IMPORTS_CHANGED.add(IBundleManifestChangeListener.Type.IMPORT_LIBRARY);
        IMPORTS_CHANGED.add(IBundleManifestChangeListener.Type.REQUIRE_BUNDLE);
    }

    @Override
    public BundleManifest getBundleManifest(IJavaProject javaProject) {
        try {
            this.r.lock();
            if (this.bundles.containsKey(javaProject)) {
                BundleManifest bundleManifest = this.bundles.get(javaProject);
                return bundleManifest;
            }
        }
        finally {
            this.r.unlock();
        }
        return this.loadBundleManifest(javaProject, false);
    }

    @Override
    public BundleManifest getTestBundleManifest(IJavaProject javaProject) {
        try {
            this.r.lock();
            if (this.testBundles.containsKey(javaProject)) {
                BundleManifest bundleManifest = this.testBundles.get(javaProject);
                return bundleManifest;
            }
        }
        finally {
            this.r.unlock();
        }
        return this.loadBundleManifest(javaProject, true);
    }

    @Override
    public Set<String> getPackageExports(IJavaProject javaProject) {
        try {
            BundleManifest bundleManifest;
            this.r.lock();
            if (this.bundles.containsKey(javaProject) && (bundleManifest = this.bundles.get(javaProject)).getExportPackage() != null && bundleManifest.getExportPackage().getExportedPackages() != null) {
                LinkedHashSet<String> packageExports = new LinkedHashSet<String>();
                for (ExportedPackage packageExport : bundleManifest.getExportPackage().getExportedPackages()) {
                    packageExports.add(packageExport.getPackageName());
                }
                LinkedHashSet<String> linkedHashSet = packageExports;
                return linkedHashSet;
            }
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Set<String> getResolvedPackageImports(IJavaProject javaProject) {
        try {
            this.r.lock();
            if (this.packageImports.containsKey(javaProject)) {
                Set<String> set = this.packageImports.get(javaProject);
                return set;
            }
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    public void start() {
        this.resourceChangeListener = new ManifestResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.bundles = null;
        this.packageImports = null;
    }

    @Override
    public void updateResolvedPackageImports(IJavaProject javaProject, Set<String> resolvedPackageImports) {
        try {
            this.w.lock();
            this.packageImports.put(javaProject, resolvedPackageImports);
        }
        finally {
            this.w.unlock();
        }
    }

    private BundleManifest loadBundleManifest(IJavaProject javaProject, boolean testBundle) {
        Map<IJavaProject, Long> timestamps;
        IFile manifestFile = BundleManifestUtils.locateManifest(javaProject, testBundle);
        BundleManifest oldBundleManifest = null;
        Map<IJavaProject, BundleManifest> manifests = testBundle ? this.testBundles : this.bundles;
        Map<IJavaProject, Long> map = timestamps = testBundle ? this.testBundleTimestamps : this.bundleTimestamps;
        if (manifestFile == null) {
            try {
                this.w.lock();
                manifests.remove(javaProject);
                timestamps.remove(javaProject);
                this.bundleManifestChanged(null, null, null, null, IMPORTS_CHANGED, javaProject);
            }
            finally {
                this.w.unlock();
            }
        }
        if (manifestFile != null) {
            this.r.lock();
            try {
                if (timestamps.containsKey(javaProject)) {
                    Long oldTimestamp = timestamps.get(javaProject);
                    oldBundleManifest = manifests.get(javaProject);
                    if (oldTimestamp >= manifestFile.getLocalTimeStamp()) {
                        BundleManifest bundleManifest = oldBundleManifest;
                        return bundleManifest;
                    }
                }
            }
            finally {
                this.r.unlock();
            }
            BundleManifest bundleManifest = BundleManifestUtils.getBundleManifest(javaProject, testBundle);
            try {
                this.w.lock();
                if (bundleManifest != null) {
                    manifests.put(javaProject, bundleManifest);
                } else {
                    manifests.remove(javaProject);
                }
                timestamps.put(javaProject, manifestFile.getLocalTimeStamp());
            }
            finally {
                this.w.unlock();
            }
            if (testBundle) {
                this.bundleManifestChanged(null, null, bundleManifest, oldBundleManifest, javaProject);
            } else {
                this.bundleManifestChanged(bundleManifest, oldBundleManifest, null, null, javaProject);
            }
            return bundleManifest;
        }
        return null;
    }

    private void updateBundleManifest(IJavaProject javaProject, boolean testBundle) {
        this.loadBundleManifest(javaProject, testBundle);
    }

    @Override
    public void addBundleManifestChangeListener(IBundleManifestChangeListener bundleManifestChangeListener) {
        this.bundleManifestChangeListeners.add(bundleManifestChangeListener);
    }

    @Override
    public void removeBundleManifestChangeListener(IBundleManifestChangeListener bundleManifestChangeListener) {
        if (this.bundleManifestChangeListeners.contains(bundleManifestChangeListener)) {
            this.bundleManifestChangeListeners.remove(bundleManifestChangeListener);
        }
    }

    private void bundleManifestChanged(BundleManifest newBundleManifest, BundleManifest oldBundleManifest, BundleManifest newTestBundleManifest, BundleManifest oldTestBundleManifest, IJavaProject javaProject) {
        HashSet<IBundleManifestChangeListener.Type> types = new HashSet<IBundleManifestChangeListener.Type>();
        types.addAll(BundleManifestDiffer.diff(newBundleManifest, oldBundleManifest));
        types.addAll(BundleManifestDiffer.diff(newTestBundleManifest, oldTestBundleManifest));
        this.bundleManifestChanged(newBundleManifest, oldBundleManifest, newTestBundleManifest, oldTestBundleManifest, types, javaProject);
    }

    private void bundleManifestChanged(BundleManifest newBundleManifest, BundleManifest oldBundleManifest, BundleManifest newTestBundleManifest, BundleManifest oldTestBundleManifest, Set<IBundleManifestChangeListener.Type> types, IJavaProject javaProject) {
        for (IBundleManifestChangeListener listener : this.bundleManifestChangeListeners) {
            listener.bundleManifestChanged(newBundleManifest, oldBundleManifest, newTestBundleManifest, oldTestBundleManifest, types, javaProject);
        }
    }

    class ManifestResourceChangeListener
    implements IResourceChangeListener {
        public static final int LISTENER_FLAGS = 14;
        private static final int VISITOR_FLAGS = 7;

        ManifestResourceChangeListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IWorkspace) {
                int eventType = event.getType();
                switch (eventType) {
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) return;
                        try {
                            delta.accept(this.getVisitor(eventType), 7);
                            return;
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.manifest.core", "Error while traversing resource change delta", (Throwable)e));
                        }
                    }
                    default: {
                        return;
                    }
                }
            } else {
                if (!(event.getSource() instanceof IProject)) return;
                int eventType = event.getType();
                switch (eventType) {
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) return;
                        try {
                            delta.accept(this.getVisitor(eventType), 7);
                            return;
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.manifest.core", "Error while traversing resource change delta", (Throwable)e));
                        }
                    }
                }
            }
        }

        protected IResourceDeltaVisitor getVisitor(int eventType) {
            return new ManifestResourceVisitor(eventType);
        }

        public boolean isTestManifest(IResource resource) {
            return resource != null && resource.isAccessible() && resource.getType() == 1 && resource.getName().equals("TEST.MF") && resource.getParent() != null && resource.getParent().getProjectRelativePath().lastSegment().equals("META-INF");
        }

        public boolean isManifest(IResource resource) {
            return resource != null && resource.isAccessible() && resource.getType() == 1 && resource.getName().equals("MANIFEST.MF") && resource.getParent() != null && resource.getParent().getProjectRelativePath().lastSegment().equals("META-INF");
        }

        protected class ManifestResourceVisitor
        implements IResourceDeltaVisitor {
            protected int eventType;

            public ManifestResourceVisitor(int eventType) {
                this.eventType = eventType;
            }

            public final boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                switch (delta.getKind()) {
                    case 1: {
                        return this.resourceAdded(resource);
                    }
                    case 16384: {
                        return this.resourceOpened(resource);
                    }
                    case 4: {
                        return this.resourceChanged(resource, delta.getFlags());
                    }
                    case 2: {
                        return this.resourceRemoved(resource);
                    }
                }
                return true;
            }

            protected boolean resourceAdded(IResource resource) {
                return true;
            }

            protected boolean resourceChanged(IResource resource, int flags) {
                if (resource instanceof IFile) {
                    if ((flags & 0x100) != 0) {
                        if (FacetUtils.isBundleProject((IResource)resource) || FacetUtils.hasProjectFacet((IResource)resource, (String)"jst.web")) {
                            if (ManifestResourceChangeListener.this.isManifest(resource)) {
                                BundleManifestManager.this.updateBundleManifest(JavaCore.create((IProject)resource.getProject()), false);
                            } else if (ManifestResourceChangeListener.this.isTestManifest(resource)) {
                                BundleManifestManager.this.updateBundleManifest(JavaCore.create((IProject)resource.getProject()), true);
                            } else if (resource.getName().equals(".classpath") && resource.getParent() instanceof IProject) {
                                BundleManifestManager.this.updateBundleManifest(JavaCore.create((IProject)resource.getProject()), false);
                                BundleManifestManager.this.updateBundleManifest(JavaCore.create((IProject)resource.getProject()), true);
                            }
                        }
                        if (resource.getName().equals("org.eclipse.wst.common.project.facet.core.xml") || resource.getName().equals("org.eclipse.virgo.ide.runtime.core.par.xml")) {
                            if (FacetUtils.isParProject((IResource)resource)) {
                                Par par = FacetUtils.getParDefinition((IProject)resource.getProject());
                                if (par != null && par.getBundle() != null) {
                                    for (Bundle bundle : par.getBundle()) {
                                        IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle.getSymbolicName());
                                        if (!FacetUtils.isBundleProject((IResource)bundleProject)) continue;
                                        this.updateBundleManifestForResource((IResource)bundleProject);
                                    }
                                }
                            } else if (FacetUtils.isBundleProject((IResource)resource)) {
                                this.updateBundleManifestForResource(resource);
                            }
                        }
                    }
                    return false;
                }
                return true;
            }

            private void updateBundleManifestForResource(IResource resource) {
                IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                BundleManifest bundleManifest = BundleManifestManager.this.getBundleManifest(javaProject);
                BundleManifest testBundleManifest = BundleManifestManager.this.getTestBundleManifest(javaProject);
                BundleManifestManager.this.bundleManifestChanged(bundleManifest, bundleManifest, testBundleManifest, testBundleManifest, IMPORTS_CHANGED, javaProject);
            }

            protected boolean resourceOpened(IResource resource) {
                return true;
            }

            protected boolean resourceRemoved(IResource resource) {
                if (ManifestResourceChangeListener.this.isManifest(resource)) {
                    BundleManifestManager.this.updateBundleManifest(JavaCore.create((IProject)resource.getProject()), false);
                } else if (ManifestResourceChangeListener.this.isTestManifest(resource)) {
                    BundleManifestManager.this.updateBundleManifest(JavaCore.create((IProject)resource.getProject()), true);
                }
                return true;
            }
        }
    }
}

