/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.deployment.DeploymentPackage;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityPackage;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.ApplicationInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.Cps2depTraceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.HostInstanceMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.StateMachineMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.StateMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.TransitionMatcher;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.TriggerPairMatcher;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.rules.eventdriven.EventDrivenTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.rules.eventdriven.EventDrivenTransformationRuleFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class RuleProvider {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.incr.viatra");
    @Extension
    private CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    @Extension
    private IModelManipulations manipulation;
    @Extension
    private DeploymentPackage depPackage = DeploymentPackage.eINSTANCE;
    @Extension
    private TraceabilityPackage trPackage = TraceabilityPackage.eINSTANCE;
    @Extension
    private EventDrivenTransformationRuleFactory factory = new EventDrivenTransformationRuleFactory();
    private CPSToDeployment cps2dep;
    private ViatraQueryEngine engine;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> hostRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> applicationRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateMachineRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> stateRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> transitionRule;
    private EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> triggerRule;

    public RuleProvider(ViatraQueryEngine engine, CPSToDeployment cps2dep) {
        this.engine = engine;
        this.cps2dep = cps2dep;
        SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(engine);
        this.manipulation = _simpleModelManipulations;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getHostRule() {
        if (this.hostRule == null) {
            IMatchProcessor _function = it -> {
                try {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Mapping host with IP: ");
                    String _nodeIp = it.getHostInstance().getNodeIp();
                    _builder.append(_nodeIp);
                    this.logger.debug((Object)_builder);
                    EObject deploymentHost = this.manipulation.createChild((EObject)this.cps2dep.getDeployment(), this.depPackage.getDeployment_Hosts(), this.depPackage.getDeploymentHost());
                    this.manipulation.set(deploymentHost, (EStructuralFeature)this.depPackage.getDeploymentHost_Ip(), (Object)it.getHostInstance().getNodeIp());
                    EObject hostTrace = this.manipulation.createChild((EObject)this.cps2dep, this.trPackage.getCPSToDeployment_Traces(), this.trPackage.getCPS2DeploymentTrace());
                    this.manipulation.addTo(hostTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getHostInstance());
                    this.manipulation.addTo(hostTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)deploymentHost);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_1 = it -> {
                try {
                    DeploymentElement _depElement = this.cpsXformM2M.getCps2depTrace(this.engine).getOneArbitraryMatch(this.cps2dep, null, (Identifiable)it.getHostInstance(), null).getDepElement();
                    DeploymentHost depHost = (DeploymentHost)_depElement;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Updating mapped host with IP: ");
                    String _ip = depHost.getIp();
                    _builder.append(_ip);
                    this.logger.debug((Object)_builder);
                    this.manipulation.set((EObject)depHost, (EStructuralFeature)this.depPackage.getDeploymentHost_Ip(), (Object)it.getHostInstance().getNodeIp());
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Updated mapped host with IP: ");
                    String _ip_1 = depHost.getIp();
                    _builder_1.append(_ip_1);
                    this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_2 = it -> {
                try {
                    Cps2depTraceMatch traceMatch = this.cpsXformM2M.getCps2depTrace(this.engine).getOneArbitraryMatch(this.cps2dep, null, (Identifiable)it.getHostInstance(), null);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Removing host with IP: ");
                    String _nodeIp = it.getHostInstance().getNodeIp();
                    _builder.append(_nodeIp);
                    this.logger.debug((Object)_builder);
                    this.manipulation.remove((EObject)this.cps2dep.getDeployment(), (EStructuralFeature)this.depPackage.getDeployment_Hosts(), (Object)traceMatch.getDepElement());
                    this.manipulation.remove((EObject)this.cps2dep, (EStructuralFeature)this.trPackage.getCPSToDeployment_Traces(), (Object)traceMatch.getTrace());
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Removed host with IP: ");
                    String _nodeIp_1 = it.getHostInstance().getNodeIp();
                    _builder_1.append(_nodeIp_1);
                    this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            this.hostRule = this.factory.createRule().name("HostRule").precondition(HostInstanceMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, _function).action(CRUDActivationStateEnum.UPDATED, _function_1).action(CRUDActivationStateEnum.DELETED, _function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
        }
        return this.hostRule;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getApplicationRule() {
        if (this.applicationRule == null) {
            IMatchProcessor _function = it -> {
                try {
                    DeploymentHost depHost = (DeploymentHost)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance().getAllocatedTo()), DeploymentHost.class));
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Mapping application with ID: ");
                    String _identifier = it.getAppInstance().getIdentifier();
                    _builder.append(_identifier);
                    this.logger.debug((Object)_builder);
                    EObject deploymentApplication = this.manipulation.createChild((EObject)depHost, this.depPackage.getDeploymentHost_Applications(), this.depPackage.getDeploymentApplication());
                    this.manipulation.set(deploymentApplication, (EStructuralFeature)this.depPackage.getDeploymentApplication_Id(), (Object)it.getAppInstance().getIdentifier());
                    EObject hostTrace = this.manipulation.createChild((EObject)this.cps2dep, this.trPackage.getCPSToDeployment_Traces(), this.trPackage.getCPS2DeploymentTrace());
                    this.manipulation.addTo(hostTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getAppInstance());
                    this.manipulation.addTo(hostTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)deploymentApplication);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Mapped application with ID: ");
                    String _identifier_1 = it.getAppInstance().getIdentifier();
                    _builder_1.append(_identifier_1);
                    this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_1 = it -> {
                try {
                    boolean _notEquals;
                    DeploymentElement _depElement = this.cpsXformM2M.getCps2depTrace(this.engine).getOneArbitraryMatch(this.cps2dep, null, (Identifiable)it.getAppInstance(), null).getDepElement();
                    DeploymentApplication depApp = (DeploymentApplication)_depElement;
                    String _id = depApp.getId();
                    String _identifier = it.getAppInstance().getIdentifier();
                    boolean bl = _notEquals = !Objects.equal((Object)_id, (Object)_identifier);
                    if (_notEquals) {
                        this.manipulation.set((EObject)depApp, (EStructuralFeature)this.depPackage.getDeploymentApplication_Id(), (Object)it.getAppInstance().getIdentifier());
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_2 = it -> {
                try {
                    CPS2DeploymentTrace _head;
                    CPS2DeploymentTrace trace = _head = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)it.getAppInstance(), null));
                    DeploymentElement _head_1 = (DeploymentElement)IterableExtensions.head((Iterable)trace.getDeploymentElements());
                    DeploymentApplication depApp = (DeploymentApplication)_head_1;
                    this.manipulation.remove((EObject)IterableExtensions.head(this.cpsXformM2M.getAllocatedDeploymentApplication(this.engine).getAllValuesOfdepHost(depApp)), (EStructuralFeature)this.depPackage.getDeploymentHost_Applications(), (Object)depApp);
                    this.manipulation.remove((EObject)this.cps2dep, (EStructuralFeature)this.trPackage.getCPSToDeployment_Traces(), (Object)trace);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            this.applicationRule = this.factory.createRule().name("ApplicationRule").precondition(ApplicationInstanceMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, _function).action(CRUDActivationStateEnum.UPDATED, _function_1).action(CRUDActivationStateEnum.DELETED, _function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
        }
        return this.applicationRule;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateMachineRule() {
        if (this.stateMachineRule == null) {
            IMatchProcessor _function = it -> {
                try {
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Mapping state machine with ID: ");
                    String _identifier = it.getStateMachine().getIdentifier();
                    _builder.append(_identifier);
                    this.logger.debug((Object)_builder);
                    EObject _createChild = this.manipulation.createChild((EObject)depApp, this.depPackage.getDeploymentApplication_Behavior(), this.depPackage.getDeploymentBehavior());
                    DeploymentBehavior behavior = (DeploymentBehavior)_createChild;
                    this.manipulation.set((EObject)behavior, (EStructuralFeature)this.depPackage.getDeploymentElement_Description(), (Object)it.getStateMachine().getIdentifier());
                    this.manipulation.set((EObject)depApp, (EStructuralFeature)this.depPackage.getDeploymentApplication_Behavior(), (Object)behavior);
                    Set<CPS2DeploymentTrace> traces = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)it.getStateMachine(), null);
                    boolean _isEmpty = traces.isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Creating new trace for state machine");
                        this.logger.trace((Object)_builder_1);
                        EObject trace = this.manipulation.createChild((EObject)this.cps2dep, this.trPackage.getCPSToDeployment_Traces(), this.trPackage.getCPS2DeploymentTrace());
                        this.manipulation.addTo(trace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getStateMachine());
                        this.manipulation.addTo(trace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)behavior);
                    } else {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Adding new behavior to existing trace");
                        this.logger.trace((Object)_builder_2);
                        this.manipulation.addTo((EObject)IterableExtensions.head(traces), (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)behavior);
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Mapped state machine with ID: ");
                    String _identifier_1 = it.getStateMachine().getIdentifier();
                    _builder_3.append(_identifier_1);
                    this.logger.debug((Object)_builder_3);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_1 = it -> {
                String smId = it.getStateMachine().getIdentifier();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Updating mapped state machine with ID: ");
                _builder.append(smId);
                this.logger.debug((Object)_builder);
                Iterable depSMs = Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getStateMachine()), DeploymentBehavior.class);
                Consumer<DeploymentBehavior> _function_2 = it_1 -> {
                    try {
                        boolean _notEquals;
                        String _description = it_1.getDescription();
                        boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)smId);
                        if (_notEquals) {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("ID changed to ");
                            _builder_1.append(smId);
                            this.logger.trace((Object)_builder_1);
                            this.manipulation.set((EObject)it_1, (EStructuralFeature)this.depPackage.getDeploymentElement_Description(), (Object)smId);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                depSMs.forEach(_function_2);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Updated mapped state machine with ID: ");
                _builder_1.append(smId);
                this.logger.debug((Object)_builder_1);
            };
            IMatchProcessor _function_2 = it -> {
                try {
                    DeploymentElement _head = (DeploymentElement)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()));
                    DeploymentApplication depApp = (DeploymentApplication)_head;
                    DeploymentBehavior depBehavior = depApp.getBehavior();
                    String smId = depBehavior.getDescription();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Removing state machine with ID: ");
                    _builder.append(smId);
                    this.logger.debug((Object)_builder);
                    this.manipulation.set((EObject)depApp, (EStructuralFeature)this.depPackage.getDeploymentApplication_Behavior(), null);
                    CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)it.getStateMachine(), null));
                    this.manipulation.remove((EObject)smTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depBehavior);
                    boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Removing empty trace");
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.remove((EObject)this.cps2dep, (EStructuralFeature)this.trPackage.getCPSToDeployment_Traces(), (Object)smTrace);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Removed state machine with ID: ");
                    _builder_2.append(smId);
                    this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            this.stateMachineRule = this.factory.createRule().name("StateMachineRule").precondition(StateMachineMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, _function).action(CRUDActivationStateEnum.UPDATED, _function_1).action(CRUDActivationStateEnum.DELETED, _function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
        }
        return this.stateMachineRule;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getStateRule() {
        if (this.stateRule == null) {
            IMatchProcessor _function = it -> {
                try {
                    Set<CPS2DeploymentTrace> traces;
                    boolean _isEmpty;
                    DeploymentElement _head = (DeploymentElement)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()));
                    DeploymentApplication depApp = (DeploymentApplication)_head;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Mapping state with ID: ");
                    String _identifier = it.getState().getIdentifier();
                    _builder.append(_identifier);
                    this.logger.debug((Object)_builder);
                    EObject depState = this.manipulation.createChild((EObject)depApp.getBehavior(), this.depPackage.getDeploymentBehavior_States(), this.depPackage.getBehaviorState());
                    this.manipulation.set(depState, (EStructuralFeature)this.depPackage.getDeploymentElement_Description(), (Object)it.getState().getIdentifier());
                    State _initial = it.getStateMachine().getInitial();
                    State _state = it.getState();
                    boolean _equals = Objects.equal((Object)_initial, (Object)_state);
                    if (_equals) {
                        this.manipulation.set((EObject)depApp.getBehavior(), (EStructuralFeature)this.depPackage.getDeploymentBehavior_Current(), (Object)depState);
                    }
                    if (_isEmpty = (traces = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)it.getState(), null)).isEmpty()) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Creating new trace for state ");
                        this.logger.trace((Object)_builder_1);
                        EObject trace = this.manipulation.createChild((EObject)this.cps2dep, this.trPackage.getCPSToDeployment_Traces(), this.trPackage.getCPS2DeploymentTrace());
                        this.manipulation.addTo(trace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)it.getState());
                        this.manipulation.addTo(trace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depState);
                    } else {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Adding new state to existing trace");
                        this.logger.trace((Object)_builder_2);
                        this.manipulation.addTo((EObject)IterableExtensions.head(traces), (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depState);
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Mapped state with ID: ");
                    String _identifier_1 = it.getState().getIdentifier();
                    _builder_3.append(_identifier_1);
                    this.logger.debug((Object)_builder_3);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_1 = it -> {
                try {
                    State _initial;
                    State _state;
                    boolean _equals;
                    boolean _notEquals;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Updating mapped state with ID: ");
                    String _identifier = it.getState().getIdentifier();
                    _builder.append(_identifier);
                    this.logger.debug((Object)_builder);
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                    Functions.Function1 _function_2 = it_1 -> depApp.getBehavior().getStates().contains(it_1);
                    BehaviorState depState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getState()), BehaviorState.class), (Functions.Function1)_function_2);
                    DeploymentBehavior depBehavior = depApp.getBehavior();
                    String _description = depState.getDescription();
                    String _identifier_1 = it.getState().getIdentifier();
                    boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)_identifier_1);
                    if (_notEquals) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("ID changed to ");
                        String _identifier_2 = it.getState().getIdentifier();
                        _builder_1.append(_identifier_2);
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.set((EObject)depState, (EStructuralFeature)this.depPackage.getDeploymentElement_Description(), (Object)it.getState().getIdentifier());
                    }
                    if (_equals = Objects.equal((Object)(_state = it.getState()), (Object)(_initial = it.getStateMachine().getInitial()))) {
                        boolean _notEquals_1;
                        BehaviorState _current = depBehavior.getCurrent();
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_current, (Object)depState);
                        if (_notEquals_1) {
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append("Current state changed to ");
                            String _identifier_3 = it.getState().getIdentifier();
                            _builder_2.append(_identifier_3);
                            this.logger.trace((Object)_builder_2);
                            this.manipulation.set((EObject)depBehavior, (EStructuralFeature)this.depPackage.getDeploymentBehavior_Current(), (Object)depState);
                        }
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Updated mapped state with ID: ");
                    String _identifier_4 = it.getState().getIdentifier();
                    _builder_3.append(_identifier_4);
                    this.logger.debug((Object)_builder_3);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_2 = it -> {
                try {
                    DeploymentElement _head = (DeploymentElement)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()));
                    DeploymentApplication depApp = (DeploymentApplication)_head;
                    DeploymentBehavior depBehavior = depApp.getBehavior();
                    Functions.Function1 _function_3 = it_1 -> depApp.getBehavior().getStates().contains(it_1);
                    BehaviorState depState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getState()), BehaviorState.class), (Functions.Function1)_function_3);
                    String stateId = depState.getDescription();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Removing state with ID: ");
                    _builder.append(stateId);
                    this.logger.debug((Object)_builder);
                    if (depBehavior != null) {
                        this.manipulation.remove((EObject)depBehavior, (EStructuralFeature)this.depPackage.getDeploymentBehavior_States(), (Object)depState);
                        BehaviorState _current = depBehavior.getCurrent();
                        boolean _equals = Objects.equal((Object)_current, (Object)depState);
                        if (_equals) {
                            this.manipulation.set((EObject)depBehavior, (EStructuralFeature)this.depPackage.getDeploymentBehavior_Current(), null);
                        }
                    }
                    CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)it.getState(), null));
                    this.manipulation.remove((EObject)smTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depState);
                    boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Removing empty trace");
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.remove((EObject)this.cps2dep, (EStructuralFeature)this.trPackage.getCPSToDeployment_Traces(), (Object)smTrace);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Removed state with ID: ");
                    _builder_2.append(stateId);
                    this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            this.stateRule = this.factory.createRule().name("StateRule").precondition(StateMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, _function).action(CRUDActivationStateEnum.UPDATED, _function_1).action(CRUDActivationStateEnum.DELETED, _function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
        }
        return this.stateRule;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getTransitionRule() {
        if (this.transitionRule == null) {
            IMatchProcessor _function = it -> {
                try {
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                    Transition transition = it.getTransition();
                    String transitionId = transition.getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Mapping transition with ID: ");
                    _builder.append(transitionId);
                    this.logger.debug((Object)_builder);
                    EObject depTransition = this.manipulation.createChild((EObject)depApp.getBehavior(), this.depPackage.getDeploymentBehavior_Transitions(), this.depPackage.getBehaviorTransition());
                    this.manipulation.set(depTransition, (EStructuralFeature)this.depPackage.getDeploymentElement_Description(), (Object)transitionId);
                    Set<DeploymentElement> tempDepSources = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getSrcState());
                    Functions.Function1 _function_1 = it_1 -> tempDepSources.contains(it_1);
                    BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_1);
                    this.manipulation.addTo((EObject)depSource, (EStructuralFeature)this.depPackage.getBehaviorState_Outgoing(), (Object)depTransition);
                    Set<DeploymentElement> tempDepTargets = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition.getTargetState());
                    Functions.Function1 _function_2 = it_1 -> tempDepTargets.contains(it_1);
                    BehaviorState depTarget = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_2);
                    this.manipulation.set(depTransition, (EStructuralFeature)this.depPackage.getBehaviorTransition_To(), (Object)depTarget);
                    Set<CPS2DeploymentTrace> traces = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)transition, null);
                    boolean _isEmpty = traces.isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Creating new trace for transition ");
                        this.logger.trace((Object)_builder_1);
                        EObject trace = this.manipulation.createChild((EObject)this.cps2dep, this.trPackage.getCPSToDeployment_Traces(), this.trPackage.getCPS2DeploymentTrace());
                        this.manipulation.addTo(trace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_CpsElements(), (Object)transition);
                        this.manipulation.addTo(trace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depTransition);
                    } else {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Adding new transition to existing trace");
                        this.logger.trace((Object)_builder_2);
                        this.manipulation.addTo((EObject)IterableExtensions.head(traces), (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depTransition);
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Mapped transition with ID: ");
                    _builder_3.append(transitionId);
                    this.logger.debug((Object)_builder_3);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_1 = it -> {
                try {
                    BehaviorState _to;
                    boolean _notEquals_1;
                    boolean _not;
                    boolean _notEquals;
                    Transition transition = it.getTransition();
                    String trId = transition.getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Updating mapped transition with ID: ");
                    _builder.append(trId);
                    this.logger.debug((Object)_builder);
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                    Set depTransitions = IterableExtensions.toSet((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition), BehaviorTransition.class));
                    Functions.Function1 _function_2 = it_1 -> depTransitions.contains(it_1);
                    BehaviorTransition depTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getTransitions(), (Functions.Function1)_function_2);
                    String oldDesc = depTransition.getDescription();
                    boolean bl = _notEquals = !Objects.equal((Object)oldDesc, (Object)trId);
                    if (_notEquals) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("ID changed to ");
                        _builder_1.append(oldDesc);
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.set((EObject)depTransition, (EStructuralFeature)this.depPackage.getDeploymentElement_Description(), (Object)trId);
                    }
                    Set<DeploymentElement> tempDepSources = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getSrcState());
                    Functions.Function1 _function_3 = it_1 -> tempDepSources.contains(it_1);
                    BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_3);
                    Set<DeploymentElement> tempDepTargets = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition.getTargetState());
                    Functions.Function1 _function_4 = it_1 -> tempDepTargets.contains(it_1);
                    BehaviorState depTarget = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_4);
                    boolean _contains = depSource.getOutgoing().contains((Object)depTransition);
                    boolean bl2 = _not = !_contains;
                    if (_not) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("Source state changed to ");
                        String _description = depSource.getDescription();
                        _builder_2.append(_description);
                        this.logger.trace((Object)_builder_2);
                        this.manipulation.addTo((EObject)depSource, (EStructuralFeature)this.depPackage.getBehaviorState_Outgoing(), (Object)depTransition);
                    }
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_to = depTransition.getTo()), (Object)depTarget);
                    if (_notEquals_1) {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("Target state changed to ");
                        String _description_1 = depTarget.getDescription();
                        _builder_3.append(_description_1);
                        this.logger.trace((Object)_builder_3);
                        this.manipulation.set((EObject)depTransition, (EStructuralFeature)this.depPackage.getBehaviorTransition_To(), (Object)depTarget);
                    }
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("Updated mapped transition with ID: ");
                    _builder_4.append(trId);
                    this.logger.debug((Object)_builder_4);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_2 = it -> {
                try {
                    Transition transition = it.getTransition();
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstance()), DeploymentApplication.class));
                    Set depTransitions = IterableExtensions.toSet((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)transition), BehaviorTransition.class));
                    Functions.Function1 _function_3 = it_1 -> depTransitions.contains(it_1);
                    BehaviorTransition depTransition = (BehaviorTransition)IterableExtensions.findFirst(this.cpsXformM2M.getDepBehaviorsStateAndTransitions(this.engine).getAllValuesOfdepTransition(depApp.getBehavior(), null), (Functions.Function1)_function_3);
                    String trId = depTransition.getDescription();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Removing transition with ID: ");
                    _builder.append(trId);
                    this.logger.debug((Object)_builder);
                    this.manipulation.set((EObject)depTransition, (EStructuralFeature)this.depPackage.getBehaviorTransition_To(), null);
                    Set<DeploymentElement> tempDepSources = this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getSrcState());
                    Functions.Function1 _function_4 = it_1 -> tempDepSources.contains(it_1);
                    BehaviorState depSource = (BehaviorState)IterableExtensions.findFirst((Iterable)depApp.getBehavior().getStates(), (Functions.Function1)_function_4);
                    if (depSource != null) {
                        this.manipulation.remove((EObject)depSource, (EStructuralFeature)this.depPackage.getBehaviorState_Outgoing(), (Object)depTransition);
                    }
                    this.manipulation.remove((EObject)depApp.getBehavior(), (EStructuralFeature)this.depPackage.getDeploymentBehavior_Transitions(), (Object)depTransition);
                    CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(null, (Identifiable)transition, null));
                    this.manipulation.remove((EObject)smTrace, (EStructuralFeature)this.trPackage.getCPS2DeploymentTrace_DeploymentElements(), (Object)depTransition);
                    boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Removing empty trace");
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.remove((EObject)this.cps2dep, (EStructuralFeature)this.trPackage.getCPSToDeployment_Traces(), (Object)smTrace);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Removed transition with ID: ");
                    _builder_2.append(trId);
                    this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            this.transitionRule = this.factory.createRule().name("TransitionRule").precondition(TransitionMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, _function).action(CRUDActivationStateEnum.UPDATED, _function_1).action(CRUDActivationStateEnum.DELETED, _function_2).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
        }
        return this.transitionRule;
    }

    public EventDrivenTransformationRule<? extends IPatternMatch, ? extends ViatraQueryMatcher<?>> getTriggerRule() {
        if (this.triggerRule == null) {
            IMatchProcessor _function = it -> {
                try {
                    boolean _not;
                    DeploymentApplication depAppTrigger = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTrigger()), DeploymentApplication.class));
                    DeploymentApplication depAppTarget = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTarget()), DeploymentApplication.class));
                    Functions.Function1 _function_1 = it_1 -> depAppTrigger.getBehavior().getTransitions().contains(it_1);
                    BehaviorTransition sendTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTrigger()), BehaviorTransition.class), (Functions.Function1)_function_1);
                    Functions.Function1 _function_2 = it_1 -> depAppTarget.getBehavior().getTransitions().contains(it_1);
                    BehaviorTransition waitTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTarget()), BehaviorTransition.class), (Functions.Function1)_function_2);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Mapping trigger between ");
                    String _description = sendTr.getDescription();
                    _builder.append(_description);
                    _builder.append(" and ");
                    String _description_1 = waitTr.getDescription();
                    _builder.append(_description_1);
                    this.logger.debug((Object)_builder);
                    boolean _contains = sendTr.getTrigger().contains((Object)waitTr);
                    boolean bl = _not = !_contains;
                    if (_not) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Adding new trigger");
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.addTo((EObject)sendTr, (EStructuralFeature)this.depPackage.getBehaviorTransition_Trigger(), (Object)waitTr);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Mapped trigger between ");
                    String _description_2 = sendTr.getDescription();
                    _builder_2.append(_description_2);
                    _builder_2.append(" and ");
                    String _description_3 = waitTr.getDescription();
                    _builder_2.append(_description_3);
                    this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            IMatchProcessor _function_1 = it -> {
                try {
                    DeploymentApplication depAppTrigger = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTrigger()), DeploymentApplication.class));
                    DeploymentApplication depAppTarget = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getAppInstanceTarget()), DeploymentApplication.class));
                    Functions.Function1 _function_2 = it_1 -> depAppTrigger.getBehavior().getTransitions().contains(it_1);
                    BehaviorTransition sendTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTrigger()), BehaviorTransition.class), (Functions.Function1)_function_2);
                    Functions.Function1 _function_3 = it_1 -> depAppTarget.getBehavior().getTransitions().contains(it_1);
                    BehaviorTransition waitTr = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfdepElement(null, null, (Identifiable)it.getCpsTarget()), BehaviorTransition.class), (Functions.Function1)_function_3);
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Removing trigger between ");
                    String _description = sendTr.getDescription();
                    _builder.append(_description);
                    _builder.append(" and ");
                    String _description_1 = waitTr.getDescription();
                    _builder.append(_description_1);
                    this.logger.debug((Object)_builder);
                    boolean _contains = sendTr.getTrigger().contains((Object)waitTr);
                    if (_contains) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Removing existing trigger");
                        this.logger.trace((Object)_builder_1);
                        this.manipulation.remove((EObject)sendTr, (EStructuralFeature)this.depPackage.getBehaviorTransition_Trigger(), (Object)waitTr);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Removed trigger between ");
                    String _description_2 = sendTr.getDescription();
                    _builder_2.append(_description_2);
                    _builder_2.append(" and ");
                    String _description_3 = waitTr.getDescription();
                    _builder_2.append(_description_3);
                    this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            this.triggerRule = this.factory.createRule().name("TriggerRule").precondition(TriggerPairMatcher.querySpecification()).action(CRUDActivationStateEnum.CREATED, _function).action(CRUDActivationStateEnum.DELETED, _function_1).addLifeCycle(Lifecycles.getDefault((boolean)true, (boolean)true)).build();
        }
        return this.triggerRule;
    }
}

