/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.ApplicationRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.HostRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.StateMachineRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.StateRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.TransitionRules;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.TriggerRules;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class CPS2DeploymentTransformation {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.expl.incr");
    @Extension
    private CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    private ExecutionSchema schema = null;
    private CPSToDeployment cps2dep;
    private ViatraQueryEngine engine;

    public void initialize(CPSToDeployment mapping, ViatraQueryEngine iqEngine) {
        Preconditions.checkArgument((mapping != null ? 1 : 0) != 0, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = mapping.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = mapping.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        Preconditions.checkArgument((iqEngine != null ? 1 : 0) != 0, (Object)"Engine cannot be null!");
        this.cps2dep = mapping;
        this.engine = iqEngine;
        this.logger.debug((Object)"Preparing queries on engine.");
        Stopwatch watch = Stopwatch.createStarted();
        this.cpsXformM2M.prepare(this.engine);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Prepared queries on engine (");
        long _elapsed = watch.stop().elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append(" ms)");
        this.logger.info((Object)_builder);
    }

    public void execute() {
        if (this.schema == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Executing transformation on:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("Cyber-physical system: ");
            String _identifier = this.cps2dep.getCps().getIdentifier();
            _builder.append(_identifier, "\t");
            this.logger.info((Object)_builder);
            this.logger.debug((Object)"Preparing transformation rules.");
            Stopwatch watch = Stopwatch.createStarted();
            ImmutableSet.Builder rulesBuilder = ImmutableSet.builder();
            rulesBuilder.addAll(HostRules.getRules(this.engine));
            rulesBuilder.addAll(ApplicationRules.getRules(this.engine));
            rulesBuilder.addAll(StateMachineRules.getRules(this.engine));
            rulesBuilder.addAll(StateRules.getRules(this.engine));
            rulesBuilder.addAll(TransitionRules.getRules(this.engine));
            rulesBuilder.addAll(TriggerRules.getRules(this.engine));
            ImmutableSet rules = rulesBuilder.build();
            UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory schedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)this.engine);
            this.schema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)this.engine, (Scheduler.ISchedulerFactory)schedulerFactory);
            Consumer<RuleSpecification> _function = it -> this.schema.addRule(it);
            rules.forEach(_function);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Prepared transformation rules (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_1.append((Object)_elapsed);
            _builder_1.append(" ms)");
            this.logger.info((Object)_builder_1);
            this.logger.debug((Object)"Initial execution of transformation rules.");
            watch.reset().start();
            this.schema.startUnscheduledExecution();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Initial execution of transformation rules finished (");
            long _elapsed_1 = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_2.append((Object)_elapsed_1);
            _builder_2.append(" ms)");
            this.logger.info((Object)_builder_2);
        }
    }

    public CPSToDeployment dispose() {
        CPSToDeployment _xblockexpression = null;
        if (this.schema != null) {
            this.schema.dispose();
        }
        this.engine = null;
        this.schema = null;
        this.cps2dep = null;
        _xblockexpression = null;
        return _xblockexpression;
    }
}

