/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import java.util.List;

public class ExecUtils {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static String osName = System.getProperty("os.name").toLowerCase();

    public static String quoteArgument(String argument) {
        String cleanedArgument = argument.trim();
        while (cleanedArgument.startsWith(SINGLE_QUOTE) && cleanedArgument.endsWith(SINGLE_QUOTE) || cleanedArgument.startsWith(DOUBLE_QUOTE) && cleanedArgument.endsWith(DOUBLE_QUOTE)) {
            cleanedArgument = cleanedArgument.substring(1, cleanedArgument.length() - 1);
        }
        StringBuilder buf = new StringBuilder();
        if (cleanedArgument.contains(DOUBLE_QUOTE)) {
            if (cleanedArgument.contains(SINGLE_QUOTE)) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return buf.append(SINGLE_QUOTE).append(cleanedArgument).append(SINGLE_QUOTE).toString();
        }
        if (cleanedArgument.contains(SINGLE_QUOTE) || cleanedArgument.contains(" ")) {
            return buf.append(DOUBLE_QUOTE).append(cleanedArgument).append(DOUBLE_QUOTE).toString();
        }
        return cleanedArgument;
    }

    public static void addArgument(List<String> args, String argument) {
        args.add(ExecUtils.quoteArgument(argument));
    }

    public static boolean isWindows() {
        return osName.contains("windows");
    }
}

