/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.spi.launcher.DefaultCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Name(value="list")
@Summary(value="List vert.x applications")
@Description(value="List all vert.x applications launched with the `start` command")
public class ListCommand
extends DefaultCommand {
    private static final Pattern PS = Pattern.compile("-Dvertx.id=(.*)\\s*");

    @Override
    public void run() {
        this.out.println("Listing vert.x applications...");
        ArrayList<String> cmd = new ArrayList<String>();
        if (!ExecUtils.isWindows()) {
            try {
                cmd.add("sh");
                cmd.add("-c");
                cmd.add("ps ax | grep \"vertx.id=\"");
                this.dumpFoundVertxApplications(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(this.out);
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
            }
        } else {
            try {
                cmd.add("WMIC");
                cmd.add("PROCESS");
                cmd.add("WHERE");
                cmd.add("CommandLine like '%java.exe%'");
                cmd.add("GET");
                cmd.add("CommandLine");
                cmd.add("/VALUE");
                this.dumpFoundVertxApplications(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(this.out);
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
            }
        }
    }

    private void dumpFoundVertxApplications(List<String> cmd) throws IOException, InterruptedException {
        String line;
        boolean none = true;
        Process process = new ProcessBuilder(cmd).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = PS.matcher(line);
            if (!matcher.find()) continue;
            this.out.println(matcher.group(1));
            none = false;
        }
        process.waitFor();
        reader.close();
        if (none) {
            this.out.println("No vert.x application found.");
        }
    }
}

