/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;

@DataObject
public class PemKeyCertOptions
implements KeyCertOptions,
Cloneable {
    private String keyPath;
    private Buffer keyValue;
    private String certPath;
    private Buffer certValue;

    public PemKeyCertOptions() {
    }

    public PemKeyCertOptions(PemKeyCertOptions other) {
        this.keyPath = other.getKeyPath();
        this.keyValue = other.getKeyValue();
        this.certPath = other.getCertPath();
        this.certValue = other.getCertValue();
    }

    public PemKeyCertOptions(JsonObject json) {
        this.keyPath = json.getString("keyPath");
        byte[] keyValue = json.getBinary("keyValue");
        this.keyValue = keyValue != null ? Buffer.buffer(keyValue) : null;
        this.certPath = json.getString("certPath");
        byte[] certValue = json.getBinary("certValue");
        this.certValue = certValue != null ? Buffer.buffer(certValue) : null;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public PemKeyCertOptions setKeyPath(String keyPath) {
        this.keyPath = keyPath;
        return this;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public Buffer getKeyValue() {
        return this.keyValue;
    }

    public PemKeyCertOptions setKeyValue(Buffer keyValue) {
        this.keyValue = keyValue;
        return this;
    }

    public PemKeyCertOptions setCertPath(String certPath) {
        this.certPath = certPath;
        return this;
    }

    public Buffer getCertValue() {
        return this.certValue;
    }

    public PemKeyCertOptions setCertValue(Buffer certValue) {
        this.certValue = certValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PemKeyCertOptions)) {
            return false;
        }
        PemKeyCertOptions that = (PemKeyCertOptions)o;
        if (this.keyPath != null ? !this.keyPath.equals(that.keyPath) : that.keyPath != null) {
            return false;
        }
        if (this.keyValue != null ? !this.keyValue.equals(that.keyValue) : that.keyValue != null) {
            return false;
        }
        if (this.certPath != null ? !this.certPath.equals(that.certPath) : that.certPath != null) {
            return false;
        }
        return !(this.certValue != null ? !this.certValue.equals(that.certValue) : that.certValue != null);
    }

    public int hashCode() {
        int result = 1;
        result += 31 * result + (this.keyPath != null ? this.keyPath.hashCode() : 0);
        result += 31 * result + (this.keyValue != null ? this.keyValue.hashCode() : 0);
        result += 31 * result + (this.certPath != null ? this.certPath.hashCode() : 0);
        result += 31 * result + (this.certValue != null ? this.certValue.hashCode() : 0);
        return result;
    }

    @Override
    public PemKeyCertOptions clone() {
        return new PemKeyCertOptions(this);
    }
}

