/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;

@DataObject
public class HttpClientOptions
extends ClientOptionsBase {
    public static final int DEFAULT_MAX_POOL_SIZE = 5;
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final boolean DEFAULT_PIPELINING = false;
    public static final boolean DEFAULT_TRY_USE_COMPRESSION = false;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final int DEFAULT_MAX_WEBSOCKET_FRAME_SIZE = 65536;
    public static final String DEFAULT_DEFAULT_HOST = "localhost";
    public static final int DEFAULT_DEFAULT_PORT = 80;
    private boolean verifyHost = true;
    private int maxPoolSize;
    private boolean keepAlive;
    private boolean pipelining;
    private boolean tryUseCompression;
    private int maxWebsocketFrameSize;
    private String defaultHost;
    private int defaultPort;

    public HttpClientOptions() {
        this.verifyHost = true;
        this.maxPoolSize = 5;
        this.keepAlive = true;
        this.pipelining = false;
        this.tryUseCompression = false;
        this.maxWebsocketFrameSize = 65536;
        this.defaultHost = DEFAULT_DEFAULT_HOST;
        this.defaultPort = 80;
    }

    public HttpClientOptions(HttpClientOptions other) {
        super(other);
        this.verifyHost = other.isVerifyHost();
        this.maxPoolSize = other.getMaxPoolSize();
        this.keepAlive = other.isKeepAlive();
        this.pipelining = other.isPipelining();
        this.tryUseCompression = other.isTryUseCompression();
        this.maxWebsocketFrameSize = other.maxWebsocketFrameSize;
        this.defaultHost = other.defaultHost;
        this.defaultPort = other.defaultPort;
    }

    public HttpClientOptions(JsonObject json) {
        super(json);
        this.verifyHost = json.getBoolean("verifyHost", true);
        this.maxPoolSize = json.getInteger("maxPoolSize", 5);
        this.keepAlive = json.getBoolean("keepAlive", true);
        this.pipelining = json.getBoolean("pipelining", false);
        this.tryUseCompression = json.getBoolean("tryUseCompression", false);
        this.maxWebsocketFrameSize = json.getInteger("maxWebsocketFrameSize", 65536);
        this.defaultHost = json.getString("defaultHost", DEFAULT_DEFAULT_HOST);
        this.defaultPort = json.getInteger("defaultPort", 80);
    }

    @Override
    public HttpClientOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public HttpClientOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public HttpClientOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public HttpClientOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public HttpClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public HttpClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public HttpClientOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public HttpClientOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public HttpClientOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public HttpClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public HttpClientOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public HttpClientOptions setPfxKeyCertOptions(PfxOptions options) {
        return (HttpClientOptions)super.setPfxKeyCertOptions(options);
    }

    @Override
    public HttpClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (HttpClientOptions)super.setPemKeyCertOptions(options);
    }

    @Override
    public HttpClientOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public HttpClientOptions setPfxTrustOptions(PfxOptions options) {
        return (HttpClientOptions)super.setPfxTrustOptions(options);
    }

    @Override
    public HttpClientOptions setPemTrustOptions(PemTrustOptions options) {
        return (HttpClientOptions)super.setPemTrustOptions(options);
    }

    @Override
    public HttpClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public HttpClientOptions addCrlPath(String crlPath) throws NullPointerException {
        return (HttpClientOptions)super.addCrlPath(crlPath);
    }

    @Override
    public HttpClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (HttpClientOptions)super.addCrlValue(crlValue);
    }

    @Override
    public HttpClientOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public HttpClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public HttpClientOptions setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be > 0");
        }
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpClientOptions setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isPipelining() {
        return this.pipelining;
    }

    public HttpClientOptions setPipelining(boolean pipelining) {
        this.pipelining = pipelining;
        return this;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public HttpClientOptions setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public boolean isTryUseCompression() {
        return this.tryUseCompression;
    }

    public HttpClientOptions setTryUseCompression(boolean tryUseCompression) {
        this.tryUseCompression = tryUseCompression;
        return this;
    }

    public int getMaxWebsocketFrameSize() {
        return this.maxWebsocketFrameSize;
    }

    public HttpClientOptions setMaxWebsocketFrameSize(int maxWebsocketFrameSize) {
        this.maxWebsocketFrameSize = maxWebsocketFrameSize;
        return this;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public HttpClientOptions setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
        return this;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public HttpClientOptions setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpClientOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpClientOptions that = (HttpClientOptions)o;
        if (this.defaultPort != that.defaultPort) {
            return false;
        }
        if (this.keepAlive != that.keepAlive) {
            return false;
        }
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.maxWebsocketFrameSize != that.maxWebsocketFrameSize) {
            return false;
        }
        if (this.pipelining != that.pipelining) {
            return false;
        }
        if (this.tryUseCompression != that.tryUseCompression) {
            return false;
        }
        if (this.verifyHost != that.verifyHost) {
            return false;
        }
        return this.defaultHost.equals(that.defaultHost);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.verifyHost ? 1 : 0);
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + (this.keepAlive ? 1 : 0);
        result = 31 * result + (this.pipelining ? 1 : 0);
        result = 31 * result + (this.tryUseCompression ? 1 : 0);
        result = 31 * result + this.maxWebsocketFrameSize;
        result = 31 * result + this.defaultHost.hashCode();
        result = 31 * result + this.defaultPort;
        return result;
    }
}

