/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.vertx.core.dns.impl.netty.DnsHeader;
import io.vertx.core.dns.impl.netty.DnsQuestion;
import io.vertx.core.dns.impl.netty.DnsResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DnsMessage<H extends DnsHeader> {
    private final List<DnsQuestion> questions = new ArrayList<DnsQuestion>();
    private final List<DnsResource> answers = new ArrayList<DnsResource>();
    private final List<DnsResource> authority = new ArrayList<DnsResource>();
    private final List<DnsResource> additional = new ArrayList<DnsResource>();
    private H header;

    public H getHeader() {
        return this.header;
    }

    public List<DnsQuestion> getQuestions() {
        return Collections.unmodifiableList(this.questions);
    }

    public List<DnsResource> getAnswers() {
        return Collections.unmodifiableList(this.answers);
    }

    public List<DnsResource> getAuthorityResources() {
        return Collections.unmodifiableList(this.authority);
    }

    public List<DnsResource> getAdditionalResources() {
        return Collections.unmodifiableList(this.additional);
    }

    public DnsMessage<H> addAnswer(DnsResource answer) {
        this.answers.add(answer);
        return this;
    }

    public DnsMessage<H> addQuestion(DnsQuestion question) {
        this.questions.add(question);
        return this;
    }

    public DnsMessage<H> addAuthorityResource(DnsResource resource) {
        this.authority.add(resource);
        return this;
    }

    public DnsMessage<H> addAdditionalResource(DnsResource resource) {
        this.additional.add(resource);
        return this;
    }

    public DnsMessage<H> setHeader(H header) {
        this.header = header;
        return this;
    }
}

