/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.model;

import javax.measure.Unit;
import org.eclipse.uomo.ucum.model.Concept;
import org.eclipse.uomo.ucum.model.ConceptKind;
import org.eclipse.uomo.ucum.model.DefinedUnit;

public abstract class UcumUnit
extends Concept
implements Unit {
    public static final UcumUnit ONE = new DefinedUnit("", "");
    private String property;

    protected UcumUnit(ConceptKind kind, String code, String codeUC) {
        super(kind, code, codeUC);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Override
    public String getDescription() {
        return String.valueOf(super.getDescription()) + " (" + this.property + ")";
    }

    public Unit<?> alternate(String a) {
        return this;
    }

    public Unit<?> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return null;
    }

    public boolean isCompatible(Unit u) {
        return u.getDimension() != null && u.getDimension().equals(this.getDimension());
    }

    public final Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public Unit<?> root(int n) {
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return null;
    }
}

