/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;

public final class TransformedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = -442449068482939939L;
    private final Unit<Q> parentUnit;
    private final AbstractConverter toParentUnit;

    @Override
    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        if (this.toParentUnit != null) {
            return this.toParentUnit.inverse();
        }
        return super.getConverterToAny(that);
    }

    public TransformedUnit(Unit<Q> parentUnit, AbstractConverter toParentUnit, String symbol) {
        if (toParentUnit == AbstractConverter.IDENTITY) {
            throw new IllegalArgumentException("Identity not allowed");
        }
        this.parentUnit = parentUnit;
        this.toParentUnit = toParentUnit;
    }

    public TransformedUnit(Unit<Q> parentUnit, AbstractConverter toParentUnit) {
        this(parentUnit, toParentUnit, null);
    }

    public Unit<Q> getParentUnit() {
        return this.parentUnit;
    }

    public UnitConverter toParentUnit() {
        return this.toParentUnit;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit thatUnit = (TransformedUnit)that;
        return this.parentUnit.equals(thatUnit.parentUnit) && this.toParentUnit != null && this.toParentUnit.equals(thatUnit.toParentUnit);
    }

    @Override
    public int hashCode() {
        return this.parentUnit.hashCode() + (this.toParentUnit != null ? this.toParentUnit.hashCode() : 0);
    }

    @Override
    protected Unit<Q> toMetric() {
        return this.parentUnit.getSystemUnit();
    }

    @Override
    public UnitConverter getConverterToMetric() {
        return ((AbstractUnit)this.parentUnit).getConverterToMetric().concatenate((UnitConverter)this.toParentUnit);
    }

    public Unit<Q> getSystemUnit() {
        return this.toMetric();
    }

    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return null;
    }
}

