/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.uomo.units.AbstractQuantity;
import org.eclipse.uomo.units.impl.NumberQuantity;
import org.eclipse.uomo.units.impl.format.QuantityFormat;

final class DoubleQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    final double value;

    public DoubleQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    public Quantity<Q> add(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().doubleValue(), this.getUnit());
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().doubleValue(), this.getUnit());
    }

    public Quantity<?> multiply(Quantity<?> that) {
        return new DoubleQuantity<Q>(this.value * that.getValue().doubleValue(), this.getUnit().multiply(that.getUnit()));
    }

    public Quantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.doubleValue(), this.getUnit());
    }

    public Quantity<?> divide(Quantity<?> that) {
        return new DoubleQuantity<Q>(this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    public Quantity<Q> divide(Number that) {
        return NumberQuantity.of(this.value / that.doubleValue(), this.getUnit());
    }

    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1.0 / this.value, this.getUnit().inverse());
    }

    @Override
    public String toString() {
        return QuantityFormat.getInstance().format(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

