/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractQuantity;
import org.eclipse.uomo.units.impl.BaseAmount;
import org.eclipse.uomo.units.impl.DoubleQuantity;
import org.eclipse.uomo.units.impl.FloatQuantity;
import org.eclipse.uomo.units.impl.IntegerQuantity;
import org.eclipse.uomo.units.impl.LongQuantity;
import org.eclipse.uomo.units.impl.ShortQuantity;

public class BaseQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Quantity<Q> {
    private final Number value;
    private final boolean isExact;
    private final boolean isBig;

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return super.equals(obj);
        }
        if (obj instanceof Quantity) {
            Quantity m = (Quantity)obj;
            if (m.getValue().getClass() == this.getValue().getClass() && m.getUnit().getClass() == this.getUnit().getClass()) {
                return super.equals(obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    protected BaseQuantity(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.isExact = false;
        this.isBig = false;
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(long longValue, Unit<Q> unit) {
        return new LongQuantity<Q>(longValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(int intValue, Unit<Q> unit) {
        return new IntegerQuantity<Q>(intValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(short value, Unit<Q> unit) {
        return new ShortQuantity<Q>(value, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(float floatValue, Unit<Q> unit) {
        return new FloatQuantity<Q>(floatValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(double doubleValue, Unit<Q> unit) {
        return new DoubleQuantity<Q>(doubleValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(BigDecimal doubleValue, Unit<Q> unit) {
        return new BaseAmount<Q>(doubleValue, unit);
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        UnitConverter converter = unit.getConverterTo(myUnit);
        return converter.convert(this.getValue().doubleValue());
    }

    @Override
    public long longValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        try {
            UnitConverter converter = unit.getConverterToAny(myUnit);
            if ((this.getValue() instanceof BigDecimal || this.getValue() instanceof BigInteger) && converter instanceof AbstractConverter) {
                return ((AbstractConverter)converter).convert(BigDecimal.valueOf(this.getValue().longValue()), MathContext.DECIMAL128).longValue();
            }
            double result = this.doubleValue(unit);
            if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
                throw new ArithmeticException("Overflow (" + result + ")");
            }
            return (long)result;
        }
        catch (UnconvertibleException e) {
            throw e;
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public boolean isExact() {
        return this.isExact;
    }

    public boolean isBig() {
        return this.isBig;
    }

    public BaseQuantity<Q> add(AbstractQuantity<Q> that) {
        Quantity<Q> thatToUnit = that.to(this.getUnit());
        return new BaseQuantity(this.getValue().doubleValue() + thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    @Override
    public String toString() {
        return String.valueOf(String.valueOf(this.getValue())) + " " + String.valueOf(this.getUnit());
    }

    public Quantity<Q> add(Quantity<Q> that) {
        return null;
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        return null;
    }

    public Quantity<?> multiply(Quantity<?> that) {
        Unit unit = this.getUnit().multiply(that.getUnit());
        return BaseQuantity.of(this.getValue().doubleValue() * that.getValue().doubleValue(), unit);
    }

    public Quantity<Q> multiply(Number that) {
        return (BaseQuantity)BaseQuantity.of(this.getValue().doubleValue() * that.doubleValue(), this.getUnit());
    }

    public Quantity<?> divide(Quantity<?> that) {
        Unit unit = this.getUnit().divide(that.getUnit());
        return BaseQuantity.of(this.getValue().doubleValue() / that.getValue().doubleValue(), unit);
    }

    public Quantity<Q> divide(Number that) {
        if (this.value instanceof BigDecimal && that instanceof BigDecimal) {
            return BaseQuantity.of(((BigDecimal)this.value).divide((BigDecimal)that), this.getUnit());
        }
        return BaseQuantity.of(this.getValue().doubleValue() / that.doubleValue(), this.getUnit());
    }

    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.value);
        }
        return BigDecimal.valueOf(this.value.doubleValue());
    }

    @Override
    public int compareTo(BaseQuantity<Q> o) {
        return 0;
    }

    public Quantity<? extends Quantity<Q>> inverse() {
        BaseQuantity<Q> m = new BaseQuantity<Q>(this.getValue(), this.getUnit().inverse());
        return m;
    }
}

