/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;

public final class RationalConverter
extends AbstractConverter {
    private static final long serialVersionUID = 5313011404391445406L;
    private final BigInteger dividend;
    private final BigInteger divisor;

    public RationalConverter(BigInteger dividend, BigInteger divisor) {
        if (divisor.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Negative or zero divisor");
        }
        if (dividend.equals(divisor)) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.dividend = dividend;
        this.divisor = divisor;
    }

    public RationalConverter(long dividend, long divisor) {
        this(BigInteger.valueOf(dividend), BigInteger.valueOf(divisor));
    }

    public static RationalConverter of(BigInteger dividend, BigInteger divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public static RationalConverter of(long dividend, long divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public BigInteger getDividend() {
        return this.dividend;
    }

    public BigInteger getDivisor() {
        return this.divisor;
    }

    public double convert(double value) {
        return value * RationalConverter.toDouble(this.dividend) / RationalConverter.toDouble(this.divisor);
    }

    private static double toDouble(BigInteger integer) {
        return integer.bitLength() < 64 ? (double)integer.longValue() : integer.doubleValue();
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        BigDecimal decimalDividend = new BigDecimal(this.dividend, 0);
        BigDecimal decimalDivisor = new BigDecimal(this.divisor, 0);
        return value.multiply(decimalDividend, ctx).divide(decimalDivisor, ctx);
    }

    public Number convert(Number value) {
        if (value instanceof BigDecimal) {
            return this.convert((BigDecimal)value, MathContext.DECIMAL128);
        }
        return this.convert(value.doubleValue());
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)converter;
            BigInteger newDividend = this.getDividend().multiply(that.getDividend());
            BigInteger newDivisor = this.getDivisor().multiply(that.getDivisor());
            BigInteger gcd = newDividend.gcd(newDivisor);
            newDividend = newDividend.divide(gcd);
            newDivisor = newDivisor.divide(gcd);
            return newDividend.equals(BigInteger.ONE) && newDivisor.equals(BigInteger.ONE) ? IDENTITY : new RationalConverter(newDividend, newDivisor);
        }
        return super.concatenate(converter);
    }

    @Override
    public RationalConverter inverse() {
        return this.dividend.signum() == -1 ? new RationalConverter(this.getDivisor().negate(), this.getDividend().negate()) : new RationalConverter(this.getDivisor(), this.getDividend());
    }

    public final String toString() {
        return "RationalConverter(" + this.dividend + "," + this.divisor + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RationalConverter)) {
            return false;
        }
        RationalConverter that = (RationalConverter)obj;
        return this.dividend.equals(that.dividend) && this.divisor.equals(that.divisor);
    }

    public int hashCode() {
        return this.dividend.hashCode() + this.divisor.hashCode();
    }

    public boolean isLinear() {
        return true;
    }
}

