/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.impl.converter.LogConverter;

public final class ExpConverter
extends AbstractConverter {
    private static final long serialVersionUID = -1862583888012861945L;
    private final double base;
    private final double logOfBase;

    public ExpConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public AbstractConverter inverse() {
        return new LogConverter(this.base);
    }

    public final String toString() {
        return "ExpConverter(" + this.base + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpConverter)) {
            return false;
        }
        ExpConverter that = (ExpConverter)obj;
        return this.base == that.base;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.base);
        return (int)(bits ^ bits >>> 32);
    }

    public double convert(double value) {
        return Math.exp(this.logOfBase * value);
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public Number convert(Number value) {
        if (value instanceof BigDecimal) {
            return this.convert((BigDecimal)value, MathContext.DECIMAL128);
        }
        return this.convert(value.doubleValue());
    }

    public boolean isLinear() {
        return false;
    }
}

