/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.impl.QuantityFactoryImpl;

public abstract class QuantityAmount<Q extends Quantity<Q>>
implements Quantity<Q> {
    private final Number number;
    private final Unit<Q> unit;
    public static final Quantity<Dimensionless> ONE = QuantityFactoryImpl.getInstance(Dimensionless.class).create((Number)BigDecimal.ONE, AbstractUnit.ONE);
    private boolean isExact;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuantityAmount other = (QuantityAmount)obj;
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    public String toString() {
        return String.valueOf(this.number);
    }

    protected QuantityAmount(Number number, Unit unit) {
        this.unit = unit;
        this.number = number;
    }

    public double doubleValue(Unit<Q> unit) {
        return this.getUnit().equals(unit) ? this.getValue().doubleValue() : this.getUnit().getConverterTo(unit).convert(this.getValue().doubleValue());
    }

    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    public Unit<Q> getUnit() {
        return this.unit;
    }

    public Number getValue() {
        return this.number;
    }

    public boolean isExact() {
        return this.isExact;
    }
}

