/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.impl;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.uomo.core.UOMoRuntimeException;
import org.eclipse.uomo.core.impl.OutputHelper;
import org.eclipse.uomo.core.impl.Pair;
import org.eclipse.uomo.ucum.UcumService;
import org.eclipse.uomo.ucum.expression.Symbol;
import org.eclipse.uomo.ucum.expression.Term;
import org.eclipse.uomo.ucum.impl.Canonical;
import org.eclipse.uomo.ucum.impl.SearchImpl;
import org.eclipse.uomo.ucum.impl.UcumConverter;
import org.eclipse.uomo.ucum.impl.UcumValidator;
import org.eclipse.uomo.ucum.model.BaseUnit;
import org.eclipse.uomo.ucum.model.Concept;
import org.eclipse.uomo.ucum.model.ConceptKind;
import org.eclipse.uomo.ucum.model.DefinedUnit;
import org.eclipse.uomo.ucum.model.UcumModel;
import org.eclipse.uomo.ucum.parsers.DefinitionParser;
import org.eclipse.uomo.ucum.parsers.ExpressionComposer;
import org.eclipse.uomo.ucum.parsers.ExpressionParser;
import org.eclipse.uomo.ucum.parsers.FormalStructureComposer;
import org.eclipse.uomo.ucum.special.SpecialUnitRegistry;

public class UcumEssenceService
implements UcumService {
    public static final String UCUM_OID = "2.16.840.1.113883.6.8";
    private final UcumModel model;
    private SpecialUnitRegistry handlers = new SpecialUnitRegistry();

    public UcumEssenceService(InputStream stream) throws UOMoRuntimeException {
        assert (stream != null) : this.paramError("factory", "stream", "must not be null");
        try {
            this.model = new DefinitionParser().parse(stream);
        }
        catch (Exception e) {
            throw new UOMoRuntimeException((Throwable)e);
        }
    }

    public UcumEssenceService(String filename) throws UOMoRuntimeException {
        assert (new File(filename).exists()) : this.paramError("factory", "file", "must exist");
        try {
            this.model = new DefinitionParser().parse(filename);
        }
        catch (Exception e) {
            throw new UOMoRuntimeException((Throwable)e);
        }
    }

    private String paramError(String method, String param, String msg) {
        return String.valueOf(this.getClass().getName()) + "." + method + "." + param + " is not acceptable: " + msg;
    }

    @Override
    public UcumService.UcumVersionDetails ucumIdentification() {
        return new UcumService.UcumVersionDetails(this.model.getRevisionDate(), this.model.getVersion());
    }

    @Override
    public UcumModel getModel() {
        return this.model;
    }

    @Override
    public List<Concept> search(ConceptKind kind, String text, boolean isRegex) {
        assert (this.checkStringParam(text)) : this.paramError("search", "text", "must not be null or empty");
        return new SearchImpl().doSearch(this.model, kind, text, isRegex);
    }

    @Override
    public List<String> validateUCUM() {
        return new UcumValidator(this.model, this.handlers).validate();
    }

    @Override
    public Set<String> getProperties() {
        HashSet<String> result = new HashSet<String>();
        for (DefinedUnit definedUnit : this.model.getDefinedUnits()) {
            result.add(definedUnit.getProperty());
        }
        for (BaseUnit baseUnit : this.model.getBaseUnits()) {
            result.add(baseUnit.getProperty());
        }
        return result;
    }

    @Override
    public String validate(String unit) {
        assert (unit != null) : this.paramError("validate", "unit", "must not be null");
        try {
            new ExpressionParser(this.model).parse(unit);
            return null;
        }
        catch (UOMoRuntimeException e) {
            return e.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String validateInProperty(String unit, String property) {
        assert (this.checkStringParam(unit)) : this.paramError("validate", "unit", "must not be null or empty");
        assert (this.checkStringParam(property)) : this.paramError("validateInProperty", "property", "must not be null or empty");
        try {
            Symbol sym;
            Term term = new ExpressionParser(this.model).parse(unit);
            Canonical can = new UcumConverter(this.model, this.handlers).convert(term);
            term = can.getUnit();
            String cu = new ExpressionComposer().compose(term);
            if (term.hasComp() && !term.hasOp() && term.getComp() instanceof Symbol && (sym = (Symbol)term.getComp()).getExponent() == 1 && sym.getUnit() instanceof BaseUnit) {
                BaseUnit b = (BaseUnit)sym.getUnit();
                if (property.equals(b.getProperty())) {
                    return null;
                }
                return "unit " + unit + " is of the property type " + b.getProperty() + " (" + cu + "), not " + property + " as required.";
            }
            if ("concentration".equals(property) && ("g/L".equals(cu) || "mol/L".equals(cu))) {
                return null;
            }
            return "unit " + unit + " has the base units " + cu + ", and are not from the property " + property + " as required.";
        }
        catch (UOMoRuntimeException e) {
            return e.getMessage();
        }
    }

    @Override
    public String validateCanonicalUnits(String unit, String canonical) {
        assert (this.checkStringParam(unit)) : this.paramError("validate", "unit", "must not be null or empty");
        assert (this.checkStringParam(canonical)) : this.paramError("validateCanonicalUnits", "canonical", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(unit);
            Canonical can = new UcumConverter(this.model, this.handlers).convert(term);
            term = can.getUnit();
            String cu = new ExpressionComposer().compose(term);
            if (!canonical.equals(cu)) {
                return "unit " + unit + " has the base units " + cu + ", not " + canonical + " as required.";
            }
            return null;
        }
        catch (UOMoRuntimeException e) {
            return e.getMessage();
        }
    }

    @Override
    public String analyse(String unit) throws UOMoRuntimeException {
        assert (this.checkStringParam(unit)) : this.paramError("analyse", "unit", "must not be null or empty");
        Term term = new ExpressionParser(this.model).parse(unit);
        return new FormalStructureComposer().compose(term);
    }

    @Override
    public String getCanonicalUnits(String unit) throws UOMoRuntimeException {
        assert (this.checkStringParam(unit)) : this.paramError("getCanonicalUnits", "unit", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(unit);
            term = new UcumConverter(this.model, this.handlers).convert(term).getUnit();
            return new ExpressionComposer().compose(term);
        }
        catch (RuntimeException e) {
            throw new UOMoRuntimeException("Error processing " + unit + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<DefinedUnit> getDefinedForms(String code) throws UOMoRuntimeException {
        assert (this.checkStringParam(code)) : this.paramError("getDefinedForms", "code", "must not be null or empty");
        ArrayList<DefinedUnit> result = new ArrayList<DefinedUnit>();
        BaseUnit base = this.model.getBaseUnit(code);
        if (base != null) {
            for (DefinedUnit unit : this.model.getDefinedUnits()) {
                if (unit.isSpecial() || !code.equals(this.getCanonicalUnits(unit.getCode()))) continue;
                result.add(unit);
            }
        }
        return result;
    }

    private boolean checkStringParam(String s) {
        return s != null && !s.equals("");
    }

    @Override
    public Pair<Number, String> getCanonicalForm(Pair<Number, String> value) throws UOMoRuntimeException {
        assert (value != null) : this.paramError("getCanonicalForm", "value", "must not be null");
        assert (this.checkStringParam((String)value.getCode())) : this.paramError("getCanonicalForm", "value.code", "must not be null or empty");
        Term term = new ExpressionParser(this.model).parse((String)value.getCode());
        Canonical c = new UcumConverter(this.model, this.handlers).convert(term);
        if (value.getValue() == null) {
            return new Pair(null, (Object)new ExpressionComposer().compose(c.getUnit()));
        }
        return new Pair((Object)((BigDecimal)value.getValue()).multiply(c.getValue()), (Object)new ExpressionComposer().compose(c.getUnit()));
    }

    @Override
    public Number convert(Number value, String sourceUnit, String destUnit) throws UOMoRuntimeException {
        String d;
        assert (value != null) : this.paramError("convert", "value", "must not be null");
        assert (this.checkStringParam(sourceUnit)) : this.paramError("convert", "sourceUnit", "must not be null or empty");
        assert (this.checkStringParam(destUnit)) : this.paramError("convert", "destUnit", "must not be null or empty");
        if (sourceUnit.equals(destUnit)) {
            return value;
        }
        Canonical src = new UcumConverter(this.model, this.handlers).convert(new ExpressionParser(this.model).parse(sourceUnit));
        Canonical dst = new UcumConverter(this.model, this.handlers).convert(new ExpressionParser(this.model).parse(destUnit));
        String s = new ExpressionComposer().compose(src.getUnit());
        if (!s.equals(d = new ExpressionComposer().compose(dst.getUnit()))) {
            throw new UOMoRuntimeException("Unable to convert between units " + sourceUnit + " and " + destUnit + " as they do not have matching canonical forms (" + s + " and " + d + " respectively)");
        }
        BigDecimal decValue = (BigDecimal)value;
        BigDecimal canValue = decValue.multiply(src.getValue());
        OutputHelper.println((String)(String.valueOf(decValue.toPlainString()) + sourceUnit + " =(" + src.getValue().toPlainString() + ")= " + canValue.toPlainString() + s + " =(" + dst.getValue().toPlainString() + ")= " + canValue.divide(dst.getValue()) + destUnit));
        return canValue.divide(dst.getValue(), new MathContext(25));
    }

    @Override
    public Pair<Number, String> multiply(Pair<Number, String> o1, Pair<Number, String> o2) {
        return new Pair((Object)((BigDecimal)o1.getValue()).multiply((BigDecimal)o2.getValue()), (Object)(String.valueOf((String)o1.getCode()) + "." + (String)o2.getCode()));
    }
}

