/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.util.numbers.impl;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.uomo.core.IValidator;
import org.eclipse.uomo.util.internal.Messages;
import org.eclipse.uomo.util.numbers.ISpellCode;
import org.eclipse.uomo.util.numbers.ISpeller;
import org.eclipse.uomo.util.numbers.SpellException;
import org.eclipse.uomo.util.numbers.impl.PatternDefinition;
import org.eclipse.uomo.util.numbers.impl.SpellCode;

public class SpellContext
implements ISpeller,
IValidator<String> {
    private static SpellContext INSTANCE;
    private static String[] mySuffixText;
    private static String[] myTeenText;
    private static String[] myCentText;
    public static boolean usingCentHyphen;
    private static final String[] mySuffixWords;
    private static final long[] mySuffixValues;
    public static CodingErrorBehavior codingErrorAction;
    private static ISpellCode[] myCodes;
    private static PatternDefinition[] mySpellPatterns;
    private static HashMap<String, ISpellCode> myNameMap;
    private static HashMap<String, ISpellCode> myCodeMap;
    private static HashMap<String, PatternDefinition> mySpellPatternMap;
    private static String myNumberPattern;
    private static boolean myInit;

    static {
        mySuffixText = new String[]{"", "", Messages.Speller_15, Messages.Speller_16, Messages.Speller_17, Messages.Speller_18, Messages.Speller_19, Messages.Speller_20};
        myTeenText = new String[]{Messages.Speller_21, Messages.Speller_22, Messages.Speller_23, Messages.Speller_24, Messages.Speller_25, Messages.Speller_26, Messages.Speller_27, Messages.Speller_28, Messages.Speller_29, Messages.Speller_30, Messages.Speller_31, Messages.Speller_32, Messages.Speller_33, Messages.Speller_34, Messages.Speller_35, Messages.Speller_36, Messages.Speller_37, Messages.Speller_38, Messages.Speller_39, Messages.Speller_40};
        myCentText = new String[]{Messages.Speller_41, Messages.Speller_42, Messages.Speller_43, Messages.Speller_44, Messages.Speller_45, Messages.Speller_46, Messages.Speller_47, Messages.Speller_48};
        usingCentHyphen = false;
        mySuffixWords = new String[]{Messages.Speller_59, Messages.Speller_60, Messages.Speller_61, Messages.Speller_62, Messages.Speller_63, Messages.Speller_64};
        mySuffixValues = new long[]{1000000000000000000L, 1000000000000000L, 1000000000000L, 1000000000L, 1000000L, 1000L};
        codingErrorAction = CodingErrorBehavior.SPECIAL_TOKEN;
        myCodes = new ISpellCode[]{new SpellCode(Messages.Speller_84, "0", 0L), new SpellCode(Messages.Speller_86, "1", 1L), new SpellCode(Messages.Speller_88, "2", 2L), new SpellCode(Messages.Speller_90, "3", 3L), new SpellCode(Messages.Speller_92, "4", 4L), new SpellCode(Messages.Speller_94, "5", 5L), new SpellCode(Messages.Speller_96, Messages.Speller_97, 6L), new SpellCode(Messages.Speller_98, "7", 7L), new SpellCode(Messages.Speller_100, "8", 8L), new SpellCode(Messages.Speller_102, "9", 9L), new SpellCode(Messages.Speller_104, "R", 10L), new SpellCode(Messages.Speller_106, "P", 11L), new SpellCode(Messages.Speller_108, "Q", 12L), new SpellCode(Messages.Speller_110, "K", 13L), new SpellCode(Messages.Speller_112, "U", 14L), new SpellCode(Messages.Speller_114, "Y", 15L), new SpellCode(Messages.Speller_116, "A", 16L), new SpellCode(Messages.Speller_118, "B", 17L), new SpellCode(Messages.Speller_120, "C", 18L), new SpellCode(Messages.Speller_122, "D", 19L), new SpellCode(Messages.Speller_124, "H", 20L), new SpellCode(Messages.Speller_126, "S", 30L), new SpellCode(Messages.Speller_128, "F", 40L), new SpellCode(Messages.Speller_130, "E", 50L), new SpellCode(Messages.Speller_132, "X", 60L), new SpellCode(Messages.Speller_134, "V", 70L), new SpellCode(Messages.Speller_136, "G", 80L), new SpellCode(Messages.Speller_138, "N", 90L), new SpellCode(Messages.Speller_140, "I", 100L), new SpellCode(Messages.Speller_142, "T", 1000L), new SpellCode(Messages.Speller_144, "M", 1000000L), new SpellCode(Messages.Speller_146, "J", 1000000000L), new SpellCode(Messages.Speller_148, "L", 1000000000000L), new SpellCode(Messages.Speller_150, "W", 1000000000000000L), new SpellCode(Messages.Speller_152, "Z", 1000000000000000000L), new SpellCode(Messages.Speller_154, "&"), new SpellCode(Messages.Speller_156, "-"), new SpellCode(Messages.Speller_158, ","), new SpellCode(Messages.Speller_160, "_")};
        mySpellPatterns = new PatternDefinition[]{new PatternDefinition("zero", "0"), new PatternDefinition("digit", Messages.Speller_165), new PatternDefinition(Messages.Speller_166, "[RPQKUYA-D]"), new PatternDefinition("teen", "$(digit)|$(odig)"), new PatternDefinition("oteen", "[HSFEXVGN](_?$(digit))?"), new PatternDefinition("cent", "$(teen)|$(oteen)"), new PatternDefinition("ocent", "$(digit)I(&?$(cent))?"), new PatternDefinition("mil", "$(cent)|$(ocent)"), new PatternDefinition("omil", "$(mil)T([,&]?$(mil))?"), new PatternDefinition("e3", "$(mil)|$(omil)"), new PatternDefinition("oe3", "$(mil)M([,&]?$(e3))?"), new PatternDefinition("e6", "$(e3)|$(oe3)"), new PatternDefinition("oe6", "$(mil)J([,&]?$(e6))?"), new PatternDefinition("e9", "$(e6)|$(oe6)"), new PatternDefinition("oe9", "$(mil)L([,&]?$(e9))?"), new PatternDefinition("e12", "$(e9)|$(oe9)"), new PatternDefinition("oe12", "$(mil)W([,&]?$(e12))?"), new PatternDefinition("e15", "$(e12)|$(oe12)"), new PatternDefinition("oe15", "$(mil)Z([,&]?$(e15))?"), new PatternDefinition("e18", "$(e15)|$(oe15)"), new PatternDefinition("num", "\\-?$(zero)|\\-?$(e18)")};
        myInit = SpellContext.init();
    }

    public static SpellContext of() {
        if (INSTANCE == null) {
            INSTANCE = new SpellContext();
        }
        return INSTANCE;
    }

    @Override
    public String spell(long number) throws SpellException {
        String text = number < 0L ? String.valueOf(Messages.Speller_0) + SpellContext.spell(-number, 1) : SpellContext.spell(number, 1);
        int index_amp = text.lastIndexOf("$");
        int index_perc = text.lastIndexOf("%");
        if (index_amp >= 0 && (index_perc < 0 || index_amp > index_perc)) {
            String textBeforeAmp = text.substring(0, index_amp);
            String textAfterAmp = text.substring(index_amp + 1, text.length());
            text = String.valueOf(textBeforeAmp) + Messages.Speller_3 + textAfterAmp;
        }
        text = text.replaceAll(Messages.Speller_4, Messages.Speller_5);
        text = text.replaceAll("%", Messages.Speller_3);
        return text;
    }

    public static String withSeparatorAlt(long number) {
        if (number < 0L) {
            return String.valueOf(Messages.Speller_8) + SpellContext.withSeparator(-number);
        }
        if (number / 1000L > 0L) {
            return String.valueOf(SpellContext.withSeparator(number / 1000L)) + Messages.Speller_9 + String.format("%1$03d", number % 1000L);
        }
        return String.format("%1$d", number);
    }

    public static String withSeparator(long number) {
        return String.format("%1$,d", number);
    }

    private static String centHyphen() {
        return usingCentHyphen ? Messages.Speller_49 : " ";
    }

    private static String SpellBelow1000(long number) throws SpellException {
        if (number < 0L || number >= 1000L) {
            throw new SpellException(String.valueOf(Messages.Speller_51) + number);
        }
        if (number < 20L) {
            return myTeenText[(int)number];
        }
        if (number < 100L) {
            int div = (int)number / 10;
            int rem = (int)number % 10;
            if (rem == 0) {
                return myCentText[div - 2];
            }
            return String.valueOf(myCentText[div - 2]) + SpellContext.centHyphen() + myTeenText[rem];
        }
        int div = (int)number / 100;
        int rem = (int)number % 100;
        String milText = String.valueOf(myTeenText[div]) + Messages.Speller_52;
        if (rem == 0) {
            return milText;
        }
        return String.valueOf(milText) + "%" + SpellContext.SpellBelow1000(rem);
    }

    private static String spell(long number, int level) throws SpellException {
        long div = number / 1000L;
        long rem = number % 1000L;
        if (div == 0L) {
            return String.valueOf(SpellContext.SpellBelow1000(rem)) + mySuffixText[level];
        }
        if (rem == 0L) {
            return SpellContext.spell(div, level + 1);
        }
        return String.valueOf(SpellContext.spell(div, level + 1)) + "$" + SpellContext.SpellBelow1000(rem) + mySuffixText[level];
    }

    private static boolean isBelowThousandWord(String text) {
        if (!myNameMap.containsKey(text)) {
            return false;
        }
        long value = myNameMap.get(text).getValue().longValue();
        return value >= 0L && value < 1000L;
    }

    private static long parseBelow1000(String text) throws SpellException {
        String[] words;
        long value = 0L;
        String[] stringArray = words = text.replaceAll(Messages.Speller_55, " ").split("\\s+");
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!SpellContext.isBelowThousandWord(word)) {
                throw new SpellException(String.valueOf(Messages.Speller_58) + word);
            }
            long subval = SpellContext.getValueOf(word);
            value = subval == 100L ? (value == 0L ? 100L : (value *= 100L)) : (value += subval);
            ++n2;
        }
        return value;
    }

    private static long getValueOf(String word) {
        return myNameMap.get(word).getValue().longValue();
    }

    @Override
    public Long parse(String text) throws SpellException {
        if ((text = SpellContext.toFriendlyString(text)).startsWith(Messages.Speller_65)) {
            String subtext = text.substring(Messages.Speller_66.length());
            if (subtext.equals("") || !Character.isWhitespace(subtext.charAt(0))) {
                throw new SpellException(String.valueOf(Messages.Speller_68) + text);
            }
            return -SpellContext.parseInternal(subtext.trim());
        }
        return SpellContext.parseInternal(text);
    }

    private static long parseInternal(String text) throws SpellException {
        long totalValue = 0L;
        boolean suffixFound = false;
        int n = 0;
        while (n < mySuffixWords.length) {
            int index = text.indexOf(mySuffixWords[n]);
            if (index >= 0) {
                String textBeforeSuffix = text.substring(0, index).trim();
                String textAfterSuffix = text.substring(index + mySuffixWords[n].length()).trim();
                if (textBeforeSuffix.equals("")) {
                    textBeforeSuffix = Messages.Speller_70;
                }
                if (textAfterSuffix.equals("")) {
                    textAfterSuffix = Messages.Speller_72;
                }
                totalValue = SpellContext.parseBelow1000(textBeforeSuffix) * mySuffixValues[n] + SpellContext.parseInternal(textAfterSuffix);
                suffixFound = true;
                break;
            }
            ++n;
        }
        if (suffixFound) {
            return totalValue;
        }
        return SpellContext.parseBelow1000(text);
    }

    private static String toFriendlyString(String text) {
        return text.toLowerCase().replaceAll("[\\-,]", " ").replaceAll(Messages.Speller_3, " ").trim();
    }

    public static String encode(String text) throws SpellException {
        text = text.toLowerCase();
        Pattern pat = Pattern.compile("(?:[\\-,]|\\w+|\\S+)");
        Matcher m = pat.matcher(text);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String token = m.group();
            if (myNameMap.containsKey(token)) {
                sb.append(myNameMap.get(token).getCode());
                continue;
            }
            if (codingErrorAction == CodingErrorBehavior.SPECIAL_TOKEN) {
                sb.append('#');
                continue;
            }
            throw new SpellException(String.valueOf(Messages.Speller_78) + token);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String text) throws SpellException {
        StringBuilder sb = new StringBuilder();
        String lastToken = null;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token;
            char c = cArray[n2];
            ISpellCode sc = myCodeMap.get(Character.toString(c));
            if (sc == null) {
                if (codingErrorAction != CodingErrorBehavior.SPECIAL_TOKEN) throw new SpellException(String.valueOf(Messages.Speller_80) + c);
                token = "(?)";
            } else {
                token = sc.getName();
            }
            if (!(lastToken == null || lastToken.equals(Messages.Speller_81) || token.equals(Messages.Speller_82) || token.equals(Messages.Speller_83))) {
                sb.append(' ');
            }
            sb.append(token);
            lastToken = token;
            ++n2;
        }
        return sb.toString();
    }

    public static String encode(long number) throws SpellException {
        return SpellContext.encode(SpellContext.of().spell(number));
    }

    public static long decodeToNumber(String text) throws SpellException {
        return SpellContext.of().parse(SpellContext.decode(text));
    }

    private static boolean init() {
        myNameMap = new HashMap();
        myCodeMap = new HashMap();
        mySpellPatternMap = new HashMap();
        Object[] objectArray = myCodes;
        int n = myCodes.length;
        int n2 = 0;
        while (n2 < n) {
            ISpellCode sc = objectArray[n2];
            myNameMap.put(sc.getName().toLowerCase(), sc);
            myCodeMap.put(sc.getCode(), sc);
            ++n2;
        }
        objectArray = mySpellPatterns;
        n = mySpellPatterns.length;
        n2 = 0;
        while (n2 < n) {
            Object pd = objectArray[n2];
            mySpellPatternMap.put(((PatternDefinition)pd).getName(), (PatternDefinition)pd);
            ++n2;
        }
        try {
            myNumberPattern = "^\\-?" + SpellContext.generatePattern("num") + "$";
        }
        catch (SpellException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void validate(String encodedText) throws SpellException {
        Pattern pat = Pattern.compile(myNumberPattern);
        Matcher mat = pat.matcher(encodedText);
        if (!mat.matches()) {
            throw new SpellException(String.valueOf(Messages.Speller_207) + encodedText);
        }
    }

    private static String generatePattern(String name) throws SpellException {
        if (!mySpellPatternMap.containsKey(name)) {
            throw new SpellException(String.valueOf(Messages.Speller_208) + name);
        }
        PatternDefinition pd = mySpellPatternMap.get(name);
        Pattern pat = Pattern.compile("\\$\\((\\w+)\\)");
        Matcher mat = pat.matcher(pd.getPackedDefinition());
        String output = pd.getPackedDefinition();
        while (mat.find()) {
            String varName = mat.group(1);
            String repText = String.format("\\$\\(%1$s\\)", varName);
            String value = String.format("(?:%1$s)", SpellContext.generatePattern(mat.group(1)));
            output = output.replaceAll(repText, value);
        }
        return output;
    }

    public static enum CodingErrorBehavior {
        SPECIAL_TOKEN,
        EXCEPTION;

    }
}

