/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.system;

import org.eclipse.uomo.units.AbstractSystemOfUnits;
import org.eclipse.uomo.units.SI;
import org.eclipse.uomo.units.impl.system.USCustomary;
import org.unitsofmeasurement.quantity.Area;
import org.unitsofmeasurement.quantity.Length;
import org.unitsofmeasurement.quantity.Mass;
import org.unitsofmeasurement.quantity.Temperature;
import org.unitsofmeasurement.quantity.Time;
import org.unitsofmeasurement.quantity.Volume;
import org.unitsofmeasurement.unit.SystemOfUnits;
import org.unitsofmeasurement.unit.Unit;

public final class Imperial
extends AbstractSystemOfUnits {
    private static final Imperial INSTANCE = new Imperial();
    public static final Unit<Length> INCH = USCustomary.INCH;
    static final Unit<Mass> POUND = Imperial.addUnit(SI.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    public static final Unit<Mass> OUNCE = Imperial.addUnit(POUND.divide(16.0));
    public static final Unit<Mass> TON_UK = Imperial.addUnit(POUND.multiply(2240.0));
    public static final Unit<Mass> METRIC_TON = Imperial.addUnit(SI.KILOGRAM.multiply(1000.0));
    static final Unit<Temperature> RANKINE = Imperial.addUnit(SI.KELVIN.multiply(5.0).divide(9.0));
    static final Unit<Temperature> FAHRENHEIT = Imperial.addUnit(RANKINE.add(459.67));
    static final Unit<Time> MINUTE = Imperial.addUnit(SI.SECOND.multiply(60.0));
    static final Unit<Time> HOUR = Imperial.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Area> SQUARE_FOOT = USCustomary.SQUARE_FOOT;
    public static final Unit<Area> ACRE = Imperial.addUnit(SQUARE_FOOT.multiply(43560.0));
    static final Unit<Volume> LITRE = Imperial.addUnit(SI.CUBIC_METRE.divide(1000.0));
    static final Unit<Volume> CUBIC_INCH = Imperial.addUnit(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> GALLON_UK = Imperial.addUnit(LITRE.multiply(454609.0).divide(100000.0));
    public static final Unit<Volume> GALLON_LIQUID = Imperial.addUnit(CUBIC_INCH.multiply(277.42));
    static final Unit<Volume> OUNCE_LIQUID_UK = Imperial.addUnit(GALLON_UK.divide(160.0));
    public static final Unit<Volume> OUNCE_LIQUID = OUNCE_LIQUID_UK;
    public static final Unit<Volume> GILL = Imperial.addUnit(OUNCE_LIQUID.multiply(5.0));
    public static final Unit<Volume> PINT = Imperial.addUnit(OUNCE_LIQUID.multiply(20.0));
    public static final Unit<Volume> QUART = Imperial.addUnit(OUNCE_LIQUID.multiply(40.0));
    public static final Unit<Volume> MINIM = Imperial.addUnit(SI.Prefix.MICRO(LITRE).multiply(59.1938802));
    public static final Unit<Volume> FLUID_SCRUPLE = Imperial.addUnit(MINIM.multiply(60.0));
    public static final Unit<Volume> FLUID_DRACHM = Imperial.addUnit(FLUID_SCRUPLE.multiply(3.0));

    private Imperial() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

