/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.IMeasure;
import org.eclipse.uomo.units.QuantityFactory;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.IncommensurableException;
import org.unitsofmeasurement.unit.UnconvertibleException;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public abstract class QuantityAmount<Q extends Quantity<Q>>
extends Measure
implements IMeasure<Q> {
    public static final Quantity<Dimensionless> ONE = QuantityFactory.getInstance(Dimensionless.class).create(BigDecimal.ONE, AbstractUnit.ONE);
    private boolean isExact;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return super.equals(obj);
        }
        if (obj instanceof Measure) {
            Measure m = (Measure)obj;
            if (m.getNumber().getClass() == this.getNumber().getClass() && m.getUnit().getClass() == this.unit().getClass()) {
                return super.equals(obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    protected QuantityAmount(Number number, MeasureUnit unit) {
        super(number, unit);
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        Unit<Q> myUnit = this.unit();
        UnitConverter converter = unit.getConverterTo(myUnit);
        return converter.convert(this.getNumber().doubleValue());
    }

    @Override
    public long longValue(Unit<Q> unit) {
        Unit<Q> myUnit = this.unit();
        try {
            UnitConverter converter = unit.getConverterToAny(myUnit);
            return converter.convert(BigDecimal.valueOf(this.getNumber().longValue()), MathContext.DECIMAL128).longValue();
        }
        catch (UnconvertibleException e) {
            throw e;
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Unit<Q> unit() {
        return this.internalUnit();
    }

    public Number value() {
        return this.getNumber();
    }

    public boolean isExact() {
        return this.isExact;
    }

    private final AbstractUnit<Q> internalUnit() {
        return (AbstractUnit)super.getUnit();
    }
}

