/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import com.ibm.icu.util.Measure;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.eclipse.uomo.core.impl.OutputHelper;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractQuantity;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.IMeasure;
import org.eclipse.uomo.units.impl.AlternateUnit;
import org.eclipse.uomo.units.impl.AnnotatedUnit;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public class BaseAmount<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Comparable<BaseAmount<Q>> {
    private final Measure measure;
    private final Number value;
    protected static final BaseAmount<Dimensionless> ONE = new BaseAmount<Dimensionless>(BigDecimal.ONE, AbstractUnit.ONE);

    public BaseAmount(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.measure = null;
    }

    public static <Q extends Quantity<Q>> BaseAmount<Q> valueOf(Number value, Unit<Q> unit) {
        BaseAmount<Q> amount = new BaseAmount<Q>(value, unit);
        return amount;
    }

    @Override
    public BaseAmount<Q> add(IMeasure<Q> that) {
        IMeasure<Q> thatToUnit = that.to(this.unit());
        return new BaseAmount(this.value().doubleValue() + thatToUnit.value().doubleValue(), this.unit());
    }

    @Override
    public BaseAmount<Q> subtract(IMeasure<Q> that) {
        IMeasure<Q> thatToUnit = that.to(this.unit());
        return new BaseAmount(this.value().doubleValue() - thatToUnit.value().doubleValue(), this.unit());
    }

    @Override
    public BaseAmount<Q> multiply(IMeasure<?> that) {
        Unit unit = this.unit().multiply(that.unit());
        return BaseAmount.valueOf(this.value().doubleValue() * that.value().doubleValue(), unit);
    }

    @Override
    public BaseAmount<?> multiply(Number that) {
        return BaseAmount.valueOf(this.value().doubleValue() * that.doubleValue(), this.unit());
    }

    @Override
    public BaseAmount<Q> divide(IMeasure<?> that) {
        Unit unit = this.unit().divide(that.unit());
        return BaseAmount.valueOf(this.value().doubleValue() / that.value().doubleValue(), unit);
    }

    @Override
    public BaseAmount<Q> to(Unit<Q> unit) {
        return this.to((Unit)unit, MathContext.DECIMAL128);
    }

    @Override
    public BaseAmount<Q> to(Unit<Q> unit, MathContext ctx) {
        if (this.unit().equals(unit)) {
            return this;
        }
        UnitConverter cvtr = this.unit().getConverterTo(unit);
        if (cvtr == AbstractConverter.IDENTITY) {
            return BaseAmount.valueOf(this.value(), unit);
        }
        return BaseAmount.valueOf(BaseAmount.convert(this.value(), cvtr, ctx), unit);
    }

    private static Number convert(Number value, UnitConverter cvtr, MathContext ctx) {
        if (cvtr instanceof RationalConverter) {
            RationalConverter rCvtr = (RationalConverter)cvtr;
            BigInteger dividend = rCvtr.getDividend();
            BigInteger divisor = rCvtr.getDivisor();
            if (dividend.abs().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new ArithmeticException("Multiplier overflow");
            }
            if (divisor.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new ArithmeticException("Divisor overflow");
            }
            if (value instanceof BigInteger || value instanceof Long || value instanceof Integer) {
                return value.longValue() * dividend.longValue() / divisor.longValue();
            }
            return value.doubleValue() * dividend.doubleValue() / divisor.doubleValue();
        }
        if (cvtr instanceof AbstractConverter.Compound && cvtr.isLinear()) {
            AbstractConverter.Compound compound = (AbstractConverter.Compound)cvtr;
            Number firstConversion = BaseAmount.convert(value, compound.getRight(), ctx);
            Number secondConversion = BaseAmount.convert(firstConversion, compound.getLeft(), ctx);
            return secondConversion;
        }
        BigDecimal decimalValue = BigDecimal.valueOf(value.doubleValue());
        BigDecimal newValue = cvtr.convert(decimalValue, ctx);
        return newValue;
    }

    public IMeasure<? extends IMeasure<Q>> pow(int exp) {
        if (exp < 0) {
            return this.pow(-exp).inverse();
        }
        if (exp == 0) {
            return ONE;
        }
        IMeasure<Object> pow2 = this;
        BaseAmount result = null;
        while (exp >= 1) {
            if ((exp & 1) == 1) {
                result = result == null ? pow2 : result.multiply(pow2);
            }
            pow2 = pow2.multiply(pow2);
            exp >>>= 1;
        }
        return result;
    }

    @Override
    public IMeasure<? extends IMeasure<Q>> inverse() {
        BaseAmount<Q> m = new BaseAmount<Q>(this.value(), this.unit().inverse());
        return m;
    }

    @Override
    public int compareTo(BaseAmount<Q> o) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BaseAmount) {
            ProductUnit pu;
            BaseUnit bu;
            AbstractUnit au;
            BaseAmount ba = (BaseAmount)obj;
            if (this.unit().getClass() == ba.unit().getClass()) {
                return super.equals(obj);
            }
            if (ba.unit() instanceof AlternateUnit) {
                AlternateUnit baa = (AlternateUnit)ba.unit();
                if (this.unit() instanceof AlternateUnit) {
                    return super.equals(obj);
                }
                if (this.unit() instanceof AnnotatedUnit) {
                    au = (AnnotatedUnit)this.unit();
                    OutputHelper.println((String)("Ann: " + au));
                } else if (this.unit() instanceof BaseUnit) {
                    bu = (BaseUnit)this.unit();
                    OutputHelper.println((String)("Bas: " + bu));
                } else if (this.unit() instanceof ProductUnit) {
                    pu = (ProductUnit)this.unit();
                    OutputHelper.println((String)("Pro: " + pu));
                } else if (this.unit() instanceof TransformedUnit) {
                    TransformedUnit tu = (TransformedUnit)this.unit();
                    OutputHelper.println((String)("Tran: " + tu));
                    if (tu.getParentUnit().equals(baa)) {
                        return true;
                    }
                } else {
                    return super.equals(obj);
                }
            }
            if (ba.unit() instanceof BaseUnit) {
                AbstractUnit au2;
                if (this.unit() instanceof AlternateUnit) {
                    au2 = (AlternateUnit)this.unit();
                    OutputHelper.println((String)("Alt: " + au2));
                } else if (this.unit() instanceof AnnotatedUnit) {
                    au2 = (AnnotatedUnit)this.unit();
                    OutputHelper.println((String)("Ann: " + au2));
                } else {
                    if (this.unit() instanceof BaseUnit) {
                        return super.equals(obj);
                    }
                    if (this.unit() instanceof ProductUnit) {
                        ProductUnit pu2 = (ProductUnit)this.unit();
                        OutputHelper.println((String)("Pro: " + pu2));
                    } else if (this.unit() instanceof TransformedUnit) {
                        TransformedUnit tu = (TransformedUnit)this.unit();
                        OutputHelper.println((String)("Tran: " + tu));
                    } else {
                        return super.equals(obj);
                    }
                }
            }
            if (ba.unit() instanceof TransformedUnit) {
                TransformedUnit bat = (TransformedUnit)ba.unit();
                if (this.unit() instanceof AlternateUnit) {
                    au = (AlternateUnit)this.unit();
                    OutputHelper.println((String)("Alt: " + au));
                    if (bat.getParentUnit().equals(au)) {
                        return true;
                    }
                } else if (this.unit() instanceof AnnotatedUnit) {
                    au = (AnnotatedUnit)this.unit();
                    System.out.println("Ann: " + au);
                } else if (this.unit() instanceof BaseUnit) {
                    bu = (BaseUnit)this.unit();
                    OutputHelper.println((String)("Bas: " + bu));
                } else if (this.unit() instanceof ProductUnit) {
                    pu = (ProductUnit)this.unit();
                    OutputHelper.println((String)("Pro: " + pu));
                } else {
                    if (this.unit() instanceof TransformedUnit) {
                        return super.equals(obj);
                    }
                    return super.equals(obj);
                }
            }
        }
        return super.equals(obj);
    }

    public Number value() {
        return this.getValue();
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isBig() {
        return this.value() instanceof BigDecimal;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        BigDecimal decimal = this.value() instanceof BigDecimal ? (BigDecimal)this.value() : BigDecimal.valueOf(this.value().doubleValue());
        return this.unit().equals(unit) ? decimal : ((AbstractConverter)this.unit().getConverterTo(unit)).convert(decimal, ctx);
    }

    @Override
    public double doubleValue(Unit<Q> unit) throws ArithmeticException {
        return this.unit().equals(unit) ? this.value().doubleValue() : this.unit().getConverterTo(unit).convert(this.value().doubleValue());
    }
}

