/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlPatternCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider.XmlModuleTestBase;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PatternAnalysisTestUtils {
    private static XmlPatternAnalysis createModule(@NonNull Element element, TmfXmlTestFiles file) {
        String id = element.getAttribute("id");
        TmfXmlPatternCu patternCu = TmfXmlPatternCu.compile((Element)element);
        Assert.assertNotNull((Object)patternCu);
        XmlPatternAnalysis module = new XmlPatternAnalysis(id, patternCu);
        module.setName(XmlModuleTestBase.getName(element));
        return module;
    }

    public static XmlPatternAnalysis initModule(TmfXmlTestFiles file) {
        Document doc = file.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("pattern");
        Element node = (Element)stateproviderNodes.item(0);
        Assert.assertNotNull((Object)node);
        XmlPatternAnalysis module = PatternAnalysisTestUtils.createModule(node, file);
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        module.setId(moduleId);
        return module;
    }
}

