/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.ITeamStateDescription;
import org.eclipse.team.ui.synchronize.TeamStateChangeEvent;
import org.eclipse.team.ui.synchronize.TeamStateDescription;
import org.eclipse.team.ui.synchronize.TeamStateProvider;

public class SubscriberTeamStateProvider
extends TeamStateProvider
implements ISubscriberChangeListener {
    private final Subscriber subscriber;

    public SubscriberTeamStateProvider(Subscriber subscriber) {
        this.subscriber = subscriber;
        subscriber.addListener((ISubscriberChangeListener)this);
    }

    @Override
    public boolean hasDecoratedState(Object element) throws CoreException {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            ResourceTraversal[] traversals;
            ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] resources;
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] iResourceArray = resources = traversal.getResources();
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource = iResourceArray[n4];
                    if (this.getSubscriber().isSupervised(resource)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    protected final int getSynchronizationState(Object element, int stateMask, IProgressMonitor monitor) throws CoreException {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            return this.getSynchronizationState(mapping, stateMask, monitor);
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int getSynchronizationState(ResourceMapping mapping, int stateMask, IProgressMonitor monitor) throws CoreException {
        compareAdapter = (ISynchronizationCompareAdapter)Adapters.adapt((Object)mapping.getModelProvider(), ISynchronizationCompareAdapter.class);
        try {
            if (compareAdapter != null && (state = compareAdapter.getSynchronizationState(this, mapping, stateMask, monitor)) != -1) {
                return state;
            }
            return this.getSubscriber().getState(mapping, stateMask, monitor);
        }
        catch (CoreException e) {
            var10_8 = projects = mapping.getProjects();
            var9_9 = projects.length;
            var8_10 = 0;
            ** while (var8_10 < var9_9)
        }
lbl-1000:
        // 1 sources

        {
            project = var10_8[var8_10];
            if (project.isAccessible()) {
                throw e;
            }
            ++var8_10;
            continue;
        }
lbl16:
        // 1 sources

        return 0;
    }

    @Override
    public ITeamStateDescription getStateDescription(Object element, int stateMask, String[] properties, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        if (stateMask == -1) {
            stateMask = this.getDecoratedStateMask(element);
        }
        return new TeamStateDescription(this.getSynchronizationState(element, stateMask, monitor));
    }

    @Override
    public ResourceMappingContext getResourceMappingContext(Object element) {
        return new SubscriberResourceMappingContext(this.subscriber, false);
    }

    protected final Subscriber getSubscriber() {
        return this.subscriber;
    }

    public void dispose() {
        this.subscriber.removeListener((ISubscriberChangeListener)this);
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        this.fireStateChangeEvent(new TeamStateChangeEvent(deltas));
    }

    @Override
    public String[] getDecoratedProperties(Object element) {
        return new String[0];
    }
}

