/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestFacility;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfSyncMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfUml2SDSyncLoaderTimeTest {
    private static final @NonNull Uml2SDTestTimestamp TC_001_TIME_VALUE = new Uml2SDTestTimestamp(9788642228395L);
    private static final String TC_001_MESSAGE_NAME = "START_GAME_REPLY";
    private static final int TC_001_PAGE_VALUE = 0;
    private static final int TC_001_START_OCCURRANCE = 6;
    private static final int TC_001_END_OCCURRANCE = 6;
    private static final String TC_001_START_LIFELINE = "Master";
    private static final String TC_001_END_LIFELINE = "player1";
    private static final @NonNull Uml2SDTestTimestamp TC_002_TIME_VALUE = new Uml2SDTestTimestamp(9789689830722L);
    private static final String TC_002_MESSAGE_NAME = "PAUSE_GAME_REQUEST";
    private static final int TC_002_PAGE_VALUE = 2;
    private static final int TC_002_START_OCCURRANCE = 7;
    private static final int TC_002_END_OCCURRANCE = 7;
    private static final String TC_002_START_LIFELINE = "player1";
    private static final String TC_002_END_LIFELINE = "Master";
    private static final @NonNull Uml2SDTestTimestamp TC_003_TIME_VALUE = new Uml2SDTestTimestamp(9790750000000L);
    private static final int TC_003_PAGE_VALUE = 4;
    private static final int TC_004_PAGE_VALUE = 0;
    private static final int TC_005_PAGE_VALUE = 8;
    private static final @NonNull Uml2SDTestTimestamp TC_006_TIME_VALUE = new Uml2SDTestTimestamp(9792420661655L);
    private static final int TC_006_PAGE_VALUE = 4;
    private static final int TC_006_START_OCCURRANCE = 10000;
    private static final int TC_006_END_OCCURRANCE = 10000;
    private static final @NonNull Uml2SDTestTimestamp TC_007_TIME_VALUE = new Uml2SDTestTimestamp(9792420756010L);
    private static final int TC_007_PAGE_VALUE = 5;
    private static final int TC_007_START_OCCURRANCE = 1;
    private static final int TC_007_END_OCCURRANCE = 1;
    private static final @NonNull Uml2SDTestTimestamp TC_008_TIME_VALUE = new Uml2SDTestTimestamp(9788642228395L);
    private static final int TC_008_PAGE_VALUE = 0;
    private static final @NonNull Uml2SDTestTimestamp TC_008_START_TIME_VALUE = new Uml2SDTestTimestamp(9788642228395L);
    private static final @NonNull Uml2SDTestTimestamp TC_008_END_TIME_VALUE = new Uml2SDTestTimestamp(9789164833324L);
    private static final @NonNull Uml2SDTestTimestamp TC_009_TIME_VALUE;
    private static final int TC_009_PAGE_VALUE = 1;
    private static final @NonNull Uml2SDTestTimestamp TC_009_START_TIME_VALUE;
    private static final @NonNull Uml2SDTestTimestamp TC_009_END_TIME_VALUE;
    private static Uml2SDTestFacility fFacility;
    private static List<GraphNode> selection;
    private static TmfSyncMessage msg;

    static {
        TC_009_START_TIME_VALUE = TC_009_TIME_VALUE = new Uml2SDTestTimestamp(9789689220871L);
        TC_009_END_TIME_VALUE = new Uml2SDTestTimestamp(9789773881426L);
    }

    @BeforeClass
    public static void setUpClass() {
        fFacility = Uml2SDTestFacility.getInstance();
        fFacility.init();
        fFacility.selectExperiment();
    }

    @AfterClass
    public static void tearDownClass() {
        fFacility.disposeExperiment();
        fFacility.dispose();
        fFacility = null;
    }

    @Test
    public void verifySynchToTimeInPage() {
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, (ITmfTimestamp)TC_001_TIME_VALUE));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"synchToTime", (long)1L, (long)selection.size());
        Assert.assertTrue((boolean)(selection.get(0) instanceof TmfSyncMessage));
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"synchToTime", (Object)TC_001_MESSAGE_NAME, (Object)msg.getName());
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)TC_001_TIME_VALUE.compareTo(msg.getStartTime()));
        Assert.assertEquals((String)"synchToTime", (long)6L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"synchToTime", (long)6L, (long)msg.getEndOccurrence());
        Assert.assertEquals((String)"synchToTime", (Object)"Master", (Object)msg.getStartLifeline().getName());
        Assert.assertEquals((String)"synchToTime", (Object)"player1", (Object)msg.getEndLifeline().getName());
    }

    @Test
    public void verifySynchToTimeOutsidePage() {
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, (ITmfTimestamp)TC_002_TIME_VALUE));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)2L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTime", selection);
        Assert.assertEquals((String)"synchToTime", (long)1L, (long)selection.size());
        Assert.assertTrue((String)"synchToTime", (boolean)(selection.get(0) instanceof TmfSyncMessage));
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"synchToTime", (Object)TC_002_MESSAGE_NAME, (Object)msg.getName());
        Assert.assertEquals((long)0L, (long)TC_002_TIME_VALUE.compareTo(msg.getStartTime()));
        Assert.assertEquals((String)"synchToTime", (long)7L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"synchToTime", (long)7L, (long)msg.getEndOccurrence());
        Assert.assertEquals((Object)"player1", (Object)msg.getStartLifeline().getName());
        Assert.assertEquals((Object)"Master", (Object)msg.getEndLifeline().getName());
    }

    @Test
    public void verifySynchToTimeNonExisting() {
        fFacility.getLoader().firstPage();
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, (ITmfTimestamp)TC_003_TIME_VALUE));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)TC_003_TIME_VALUE.compareTo(fFacility.getLoader().getCurrentTime()));
        Assert.assertEquals((String)"synchToTime", (long)4L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTime", selection);
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)selection.size());
    }

    @Test
    public void verifySynchToTimeBeforeExpStart() {
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.BIG_BANG));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTime", selection);
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)selection.size());
    }

    @Test
    public void verifySynchToTimeAfterExpEnd() {
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.BIG_CRUNCH));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)8L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull(selection);
        Assert.assertEquals((String)"synchToTime", (long)0L, (long)selection.size());
    }

    @Test
    public void verifySynchToTimeEqualsLast() {
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, (ITmfTimestamp)TC_006_TIME_VALUE));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)4L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTime", selection);
        Assert.assertEquals((String)"synchToTime", (long)1L, (long)selection.size());
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"synchToTime", (long)10000L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"synchToTime", (long)10000L, (long)msg.getEndOccurrence());
    }

    @Test
    public void verifySynchToTimeFirst() {
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, (ITmfTimestamp)TC_007_TIME_VALUE));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTime", (long)5L, (long)fFacility.getLoader().currentPage());
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTime", selection);
        msg = (TmfSyncMessage)selection.get(0);
        Assert.assertEquals((String)"synchToTime", (long)1L, (long)selection.size());
        Assert.assertEquals((String)"synchToTime", (long)1L, (long)msg.getStartOccurrence());
        Assert.assertEquals((String)"synchToTime", (long)1L, (long)msg.getEndOccurrence());
    }

    @Test
    public void verifyTimeRangeSamePage() {
        fFacility.getLoader().firstPage();
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)TC_008_START_TIME_VALUE, (ITmfTimestamp)TC_008_END_TIME_VALUE);
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        fFacility.getTrace().broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        Assert.assertEquals((String)"synchToTimeRange", (long)0L, (long)fFacility.getLoader().currentPage());
        Assert.assertNotNull((String)"synchToTimeRange", (Object)fFacility.getLoader().getCurrentTime());
        Assert.assertEquals((String)"synchToTimeRange", (long)0L, (long)TC_008_TIME_VALUE.compareTo(fFacility.getLoader().getCurrentTime()));
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTimeRange", selection);
        Assert.assertEquals((String)"synchToTimeRange", (long)0L, (long)selection.size());
    }

    @Test
    public void verifyTimeRangeDifferentPages() {
        TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)TC_009_START_TIME_VALUE, (ITmfTimestamp)TC_009_END_TIME_VALUE);
        fFacility.getTrace().broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, range));
        fFacility.getLoader().waitForCompletion();
        fFacility.delay(1000L);
        Assert.assertEquals((String)"synchToTimeRange", (long)1L, (long)fFacility.getLoader().currentPage());
        Assert.assertNotNull((String)"synchToTimeRange", (Object)fFacility.getLoader().getCurrentTime());
        Assert.assertEquals((String)"synchToTimeRange", (long)0L, (long)TC_009_TIME_VALUE.compareTo(fFacility.getLoader().getCurrentTime()));
        selection = fFacility.getSdView().getSDWidget().getSelection();
        Assert.assertNotNull((String)"synchToTimeRange", selection);
        Assert.assertEquals((String)"synchToTimeRange", (long)0L, (long)selection.size());
    }
}

