/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.LoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.UstProviderInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UstProviderInfoTest {
    private IUstProviderInfo fUstProviderInfo1 = null;
    private IUstProviderInfo fUstProviderInfo2 = null;
    private IBaseEventInfo fEventInfo1 = null;
    private IBaseEventInfo fEventInfo2 = null;
    private ILoggerInfo fLoggerInfo1 = null;
    private ILoggerInfo fLoggerInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fUstProviderInfo1 = factory.getUstProviderInfo1();
        this.fUstProviderInfo2 = factory.getUstProviderInfo2();
        this.fEventInfo1 = factory.getBaseEventInfo1();
        this.fEventInfo2 = factory.getBaseEventInfo2();
        this.fLoggerInfo1 = factory.getLoggerInfo1();
        this.fLoggerInfo2 = factory.getLoggerInfo2();
    }

    @Test
    public void testUstProviderInfo() {
        UstProviderInfo result = new UstProviderInfo("test");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result.getName());
        Assert.assertEquals((long)0L, (long)result.getPid());
        Assert.assertEquals((long)0L, (long)result.getEvents().length);
        Assert.assertEquals((long)0L, (long)result.getLoggers().size());
    }

    @Test
    public void testUstProviderInfoCopy() {
        UstProviderInfo providerInf = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo1);
        Assert.assertEquals((Object)this.fUstProviderInfo1.getName(), (Object)providerInf.getName());
        Assert.assertEquals((long)this.fUstProviderInfo1.getPid(), (long)providerInf.getPid());
        Assert.assertEquals((long)this.fUstProviderInfo1.getEvents().length, (long)providerInf.getEvents().length);
        Assert.assertEquals((long)this.fUstProviderInfo1.getLoggers().size(), (long)providerInf.getLoggers().size());
        IBaseEventInfo[] orignalEvents = this.fUstProviderInfo1.getEvents();
        IBaseEventInfo[] resultEvents = providerInf.getEvents();
        int i = 0;
        while (i < orignalEvents.length) {
            Assert.assertEquals((Object)orignalEvents[i], (Object)resultEvents[i]);
            ++i;
        }
        List originalLoggers = this.fUstProviderInfo1.getLoggers();
        List resultLoggers = providerInf.getLoggers();
        int i2 = 0;
        while (i2 < originalLoggers.size()) {
            Assert.assertEquals(originalLoggers.get(i2), resultLoggers.get(i2));
            ++i2;
        }
    }

    @Test
    public void testUstProviderCopy2() {
        try {
            UstProviderInfo providerInfo = null;
            new UstProviderInfo(providerInfo);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testGetAndSetters() {
        UstProviderInfo fixture = new UstProviderInfo("test");
        fixture.setPid(2468);
        Assert.assertEquals((long)2468L, (long)fixture.getPid());
        BaseEventInfo event = new BaseEventInfo("event");
        fixture.addEvent((IBaseEventInfo)event);
        IBaseEventInfo[] events = fixture.getEvents();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.length);
        Assert.assertNotNull((Object)events[0]);
        Assert.assertTrue((boolean)event.equals(events[0]));
        LoggerInfo logger = new LoggerInfo("logger");
        fixture.addLogger((ILoggerInfo)logger);
        List loggers = fixture.getLoggers();
        Assert.assertNotNull((Object)loggers);
        Assert.assertEquals((long)1L, (long)loggers.size());
        Assert.assertNotNull(loggers.get(0));
        Assert.assertTrue((boolean)logger.equals(loggers.get(0)));
    }

    @Test
    public void testSetEvents_1() {
        UstProviderInfo fixture = new UstProviderInfo("test");
        LinkedList<IBaseEventInfo> events = new LinkedList<IBaseEventInfo>();
        events.add(this.fEventInfo1);
        events.add(this.fEventInfo2);
        fixture.setEvents(events);
        IBaseEventInfo[] infos = fixture.getEvents();
        Assert.assertEquals((long)events.size(), (long)infos.length);
        int i = 0;
        while (i < infos.length) {
            Assert.assertEquals(events.get(i), (Object)infos[i]);
            ++i;
        }
    }

    @Test
    public void testSetLoggers_1() {
        UstProviderInfo fixture = new UstProviderInfo("test");
        LinkedList<ILoggerInfo> originalLoggers = new LinkedList<ILoggerInfo>();
        originalLoggers.add(this.fLoggerInfo1);
        originalLoggers.add(this.fLoggerInfo2);
        fixture.setLoggers(originalLoggers);
        List resultLoggers = fixture.getLoggers();
        Assert.assertEquals((long)originalLoggers.size(), (long)resultLoggers.size());
        int i = 0;
        while (i < resultLoggers.size()) {
            Assert.assertEquals(originalLoggers.get(i), resultLoggers.get(i));
            ++i;
        }
    }

    @Test
    public void testToString_1() {
        UstProviderInfo fixture = new UstProviderInfo("test");
        fixture.setPid(2468);
        String result = fixture.toString();
        Assert.assertEquals((Object)"[UstProviderInfo([TraceInfo(Name=test)],PID=2468,Events=None,Loggers=None)]", (Object)result);
    }

    @Test
    public void testToString_2() {
        String result = this.fUstProviderInfo2.toString();
        Assert.assertEquals((Object)"[UstProviderInfo([TraceInfo(Name=myUST2)],PID=2345,Events=[BaseEventInfo([TraceInfo(Name=event1)],type=UNKNOWN,level=TRACE_ERR,Fields=[FieldInfo([TraceInfo(Name=intfield)],type=int[FieldInfo([TraceInfo(Name=stringfield)],type=string,Filter=intField==10)][BaseEventInfo([TraceInfo(Name=event2)],type=TRACEPOINT,level=TRACE_DEBUG)],Loggers=[LoggerInfo([BaseLoggerInfo([TraceInfo(Name=logger1)],domain=JUL,level=LOG4J_INFO)],State=ENABLED,levelType=LOGLEVEL_ALL)][LoggerInfo([BaseLoggerInfo([TraceInfo(Name=logger2)],domain=LOG4J,level=LEVEL_UNKNOWN)],State=DISABLED,levelType=LOGLEVEL_ALL)])]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fUstProviderInfo1.equals(this.fUstProviderInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fUstProviderInfo2.equals(this.fUstProviderInfo2));
        Assert.assertTrue((String)"equals", (!this.fUstProviderInfo1.equals(this.fUstProviderInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fUstProviderInfo2.equals(this.fUstProviderInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        UstProviderInfo event1 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo1);
        UstProviderInfo event2 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo2);
        Assert.assertTrue((String)"equals", (boolean)event1.equals((Object)this.fUstProviderInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fUstProviderInfo1.equals(event1));
        Assert.assertTrue((String)"equals", (boolean)event2.equals((Object)this.fUstProviderInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fUstProviderInfo2.equals(event2));
    }

    @Test
    public void testEqualsTransivity() {
        UstProviderInfo UstProvider1 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo1);
        UstProviderInfo UstProvider2 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo1);
        UstProviderInfo UstProvider3 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo1);
        Assert.assertTrue((String)"equals", (boolean)UstProvider1.equals((Object)UstProvider2));
        Assert.assertTrue((String)"equals", (boolean)UstProvider2.equals((Object)UstProvider3));
        Assert.assertTrue((String)"equals", (boolean)UstProvider1.equals((Object)UstProvider3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fUstProviderInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fUstProviderInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        UstProviderInfo UstProvider1 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo1);
        UstProviderInfo UstProvider2 = new UstProviderInfo((UstProviderInfo)this.fUstProviderInfo2);
        Assert.assertTrue((String)"hashCode", (this.fUstProviderInfo1.hashCode() == UstProvider1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fUstProviderInfo2.hashCode() == UstProvider2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fUstProviderInfo1.hashCode() != UstProvider2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fUstProviderInfo2.hashCode() != UstProvider1.hashCode() ? 1 : 0) != 0);
    }
}

