/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.EventInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventInfoTest {
    private IEventInfo fEventInfo1 = null;
    private IEventInfo fEventInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fEventInfo1 = factory.getEventInfo1();
        this.fEventInfo2 = factory.getEventInfo2();
    }

    @Test
    public void testBaseEventInfo() {
        EventInfo fixture = new EventInfo("event");
        Assert.assertNotNull((Object)fixture);
        TraceEventType result = fixture.getEventType();
        Assert.assertEquals((Object)"event", (Object)fixture.getName());
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        TraceEnablement state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        LogLevelType logType = fixture.getLogLevelType();
        Assert.assertEquals((Object)"", (Object)logType.getShortName());
        Assert.assertEquals((Object)"LOGLEVEL_NONE", (Object)logType.name());
        Assert.assertEquals((Object)"LOGLEVEL_NONE", (Object)logType.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
    }

    @Test
    public void testEventInfoCopy() {
        EventInfo info = new EventInfo((EventInfo)this.fEventInfo1);
        Assert.assertEquals((Object)this.fEventInfo1.getName(), (Object)info.getName());
        Assert.assertEquals((Object)this.fEventInfo1.getEventType(), (Object)info.getEventType());
        Assert.assertEquals((Object)this.fEventInfo1.getState(), (Object)info.getState());
        Assert.assertEquals((Object)this.fEventInfo1.getLogLevelType(), (Object)info.getLogLevelType());
    }

    @Test
    public void testEventCopy2() {
        try {
            EventInfo info = null;
            new EventInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testGetAndSetter() {
        EventInfo fixture = new EventInfo("event");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        TraceEventType result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"tracepoint", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACEPOINT", (Object)result.name());
        Assert.assertEquals((Object)"TRACEPOINT", (Object)result.toString());
        Assert.assertEquals((long)0L, (long)result.ordinal());
        fixture.setEventType(TraceEventType.UNKNOWN);
        result = fixture.getEventType();
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        String typeName = "";
        fixture.setEventType(typeName);
        result = fixture.getEventType();
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        typeName = "unknown";
        fixture.setEventType(typeName);
        result = fixture.getEventType();
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        fixture.setState("disabled");
        TraceEnablement state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState("false");
        state = fixture.getState();
        Assert.assertEquals((Object)"false", (Object)state.getInMiName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState("bla");
        state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState("enabled");
        state = fixture.getState();
        Assert.assertEquals((Object)"enabled", (Object)state.getInName());
        Assert.assertEquals((Object)"ENABLED", (Object)state.name());
        Assert.assertEquals((Object)"ENABLED", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        fixture.setState("true");
        state = fixture.getState();
        Assert.assertEquals((Object)"true", (Object)state.getInMiName());
        Assert.assertEquals((Object)"ENABLED", (Object)state.name());
        Assert.assertEquals((Object)"ENABLED", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        fixture.setState(TraceEnablement.DISABLED);
        state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        fixture.setState(TraceEnablement.ENABLED);
        state = fixture.getState();
        Assert.assertEquals((Object)"enabled", (Object)state.getInName());
        Assert.assertEquals((Object)"ENABLED", (Object)state.name());
        Assert.assertEquals((Object)"ENABLED", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        fixture.setLogLevelType("==");
        Assert.assertEquals((Object)"LOGLEVEL_ONLY", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"==", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType("<=");
        Assert.assertEquals((Object)"LOGLEVEL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"<=", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType("All");
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"All", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_ONLY);
        Assert.assertEquals((Object)"LOGLEVEL_ONLY", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"==", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL);
        Assert.assertEquals((Object)"LOGLEVEL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"<=", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_ALL);
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"All", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_NONE);
        Assert.assertEquals((Object)"LOGLEVEL_NONE", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"", (Object)fixture.getLogLevelType().getShortName());
        fixture.setLogLevelType("SINGLE");
        Assert.assertEquals((Object)"LOGLEVEL_ONLY", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"SINGLE", (Object)fixture.getLogLevelType().getMiName());
        fixture.setLogLevelType("RANGE");
        Assert.assertEquals((Object)"LOGLEVEL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"RANGE", (Object)fixture.getLogLevelType().getMiName());
        fixture.setLogLevelType("ALL");
        Assert.assertEquals((Object)"LOGLEVEL_ALL", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"ALL", (Object)fixture.getLogLevelType().getMiName());
        fixture.setLogLevelType("UNKNOWN");
        Assert.assertEquals((Object)"LOGLEVEL_NONE", (Object)fixture.getLogLevelType().name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)fixture.getLogLevelType().getMiName());
    }

    @Test
    public void testToString_1() {
        EventInfo fixture = new EventInfo("event");
        fixture.setName("testName");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        String result = fixture.toString();
        Assert.assertEquals((Object)"[EventInfo([BaseEventInfo([TraceInfo(Name=testName)],type=TRACEPOINT,level=TRACE_DEBUG)],State=DISABLED,levelType=LOGLEVEL_NONE)]", (Object)result);
    }

    @Test
    public void testToString_2() {
        EventInfo fixture = new EventInfo("event");
        fixture.setName("testName");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        fixture.setLogLevelType(LogLevelType.LOGLEVEL_ONLY);
        String result = fixture.toString();
        Assert.assertEquals((Object)"[EventInfo([BaseEventInfo([TraceInfo(Name=testName)],type=TRACEPOINT,level=TRACE_DEBUG)],State=DISABLED,levelType=LOGLEVEL_ONLY)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo1.equals(this.fEventInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo2.equals(this.fEventInfo2));
        Assert.assertTrue((String)"equals", (!this.fEventInfo1.equals(this.fEventInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventInfo2.equals(this.fEventInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        EventInfo info1 = new EventInfo((EventInfo)this.fEventInfo1);
        EventInfo info2 = new EventInfo((EventInfo)this.fEventInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fEventInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fEventInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        EventInfo info1 = new EventInfo((EventInfo)this.fEventInfo1);
        EventInfo info2 = new EventInfo((EventInfo)this.fEventInfo1);
        EventInfo info3 = new EventInfo((EventInfo)this.fEventInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fEventInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        EventInfo info1 = new EventInfo((EventInfo)this.fEventInfo1);
        EventInfo info2 = new EventInfo((EventInfo)this.fEventInfo2);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

