/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.floatingpoint;

import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.AlignmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.ByteOrderParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class FloatDeclarationParser
implements ICommonTreeParser {
    private static final String FLOAT_UNKNOWN_ATTRIBUTE = "Float: unknown attribute ";
    private static final String FLOAT_MISSING_SIZE_ATTRIBUTE = "Float: missing size attribute";
    private static final String IDENTIFIER_MUST_BE_A_STRING = "Left side of ctf expression must be a string";
    public static final FloatDeclarationParser INSTANCE = new FloatDeclarationParser();
    private static final int DEFAULT_FLOAT_EXPONENT = 8;
    private static final int DEFAULT_FLOAT_MANTISSA = 24;

    private FloatDeclarationParser() {
    }

    @Override
    public FloatDeclaration parse(ICTFMetadataNode floatingPoint, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        CTFTrace trace = ((Param)param).fTrace;
        List<ICTFMetadataNode> children = floatingPoint.getChildren();
        if (children == null) {
            throw new ParseException(FLOAT_MISSING_SIZE_ATTRIBUTE);
        }
        ByteOrder byteOrder = trace.getByteOrder();
        long alignment = 0L;
        int exponent = 8;
        int mantissa = 24;
        for (ICTFMetadataNode child : children) {
            String type = child.getType();
            if (CTFParser.tokenNames[86].equals(type)) {
                ICTFMetadataNode leftNode = child.getChild(0);
                ICTFMetadataNode rightNode = child.getChild(1);
                List<ICTFMetadataNode> leftStrings = leftNode.getChildren();
                if (!TsdlUtils.isAnyUnaryString(leftStrings.get(0))) {
                    throw new ParseException(IDENTIFIER_MUST_BE_A_STRING);
                }
                String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
                if (left.equals("exp_dig")) {
                    exponent = UnaryIntegerParser.INSTANCE.parse(rightNode.getChild(0), null).intValue();
                    continue;
                }
                if (left.equals("byte_order")) {
                    byteOrder = ByteOrderParser.INSTANCE.parse(rightNode, new ByteOrderParser.Param(trace));
                    continue;
                }
                if (left.equals("mant_dig")) {
                    mantissa = UnaryIntegerParser.INSTANCE.parse(rightNode.getChild(0), null).intValue();
                    continue;
                }
                if (left.equals("align")) {
                    alignment = AlignmentParser.INSTANCE.parse(rightNode, null);
                    continue;
                }
                throw new ParseException(FLOAT_UNKNOWN_ATTRIBUTE + left);
            }
            throw TsdlUtils.childTypeError(child);
        }
        int size = mantissa + exponent;
        if (size == 0) {
            throw new ParseException(FLOAT_MISSING_SIZE_ATTRIBUTE);
        }
        if (alignment == 0L) {
            alignment = 1L;
        }
        return new FloatDeclaration(exponent, mantissa, byteOrder, alignment);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;

        public Param(CTFTrace trace) {
            this.fTrace = trace;
        }
    }
}

