/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.CallStackTestData;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.CallStackProviderStub;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public class TestDataBigCallStack
extends CallStackTestData {
    private static final String CALLSTACK_FILE = "testfiles/traces/callstackBig.xml";
    private boolean fDataInitialized = false;
    private long fEnd = 0L;
    private long fStart = Long.MAX_VALUE;

    @Override
    public @NonNull ITmfTrace getTrace() {
        ITmfTrace trace = super.getTrace();
        if (!this.fDataInitialized) {
            this.setCallStackData(this.getExpectedData(trace));
            this.fDataInitialized = true;
        }
        return trace;
    }

    @Override
    protected @NonNull String getTraceFile() {
        return CALLSTACK_FILE;
    }

    @Override
    protected long getStartTime() {
        return this.fStart;
    }

    @Override
    protected long getEndTime() {
        return this.fEnd;
    }

    private List<CallStackTestData.ExpectedCallStackElement> getExpectedData(ITmfTrace trace) {
        ExpectedDataBuildingRequest request = new ExpectedDataBuildingRequest();
        trace.sendRequest((ITmfEventRequest)request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Request was interrupted");
        }
        return request.getExpectedData();
    }

    private class ExpectedDataBuildingRequest
    extends TmfEventRequest {
        Map<Long, Stack<OpenedFunction>> fOpenedFct;
        Map<Long, OpenedElement> fOpenedElements;

        public ExpectedDataBuildingRequest() {
            super(ITmfEvent.class, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fOpenedFct = new HashMap<Long, Stack<OpenedFunction>>();
            this.fOpenedElements = new HashMap<Long, OpenedElement>();
        }

        public List<CallStackTestData.ExpectedCallStackElement> getExpectedData() {
            ArrayList<CallStackTestData.ExpectedCallStackElement> list = new ArrayList<CallStackTestData.ExpectedCallStackElement>();
            for (OpenedElement element : this.fOpenedElements.values()) {
                list.add(new CallStackTestData.ExpectedCallStackElement(element.fPid, element.fTid, element.fCalls));
            }
            return list;
        }

        public void handleData(ITmfEvent event) {
            String name;
            super.handleData(event);
            long ts = event.getTimestamp().toNanos();
            TestDataBigCallStack.this.fStart = Math.min(ts, TestDataBigCallStack.this.fStart);
            TestDataBigCallStack.this.fEnd = Math.max(ts, TestDataBigCallStack.this.fEnd);
            long tid = CallStackProviderStub.getThreadIdFromEvent(event);
            if (tid == -1L) {
                return;
            }
            Stack<OpenedFunction> stack = this.fOpenedFct.get(tid);
            if (stack == null) {
                stack = new Stack();
                this.fOpenedFct.put(tid, stack);
            }
            if ((name = event.getName()).equals("entry")) {
                ITmfEventField field = event.getContent().getField(new String[]{"op"});
                if (field == null) {
                    return;
                }
                stack.push(new OpenedFunction(ts, field.getValue().toString()));
            } else if (name.equals("exit")) {
                if (stack.isEmpty()) {
                    return;
                }
                OpenedFunction toClose = stack.pop();
                CallStackTestData.ExpectedFunction closedFunction = toClose.closeFunction(ts);
                if (stack.isEmpty()) {
                    OpenedElement openedElement = this.fOpenedElements.get(tid);
                    if (openedElement == null) {
                        openedElement = this.createElementFromEvent(event, tid);
                    }
                    openedElement.fCalls.add(closedFunction);
                } else {
                    OpenedFunction parent = stack.peek();
                    parent.fChildren.add(closedFunction);
                }
            }
        }

        private OpenedElement createElementFromEvent(ITmfEvent event, long tid) {
            int pid = CallStackProviderStub.getProcessIdFromEvent(event);
            if (pid == -1) {
                throw new NullPointerException("There should be a pid field");
            }
            OpenedElement openedElement = new OpenedElement(pid, (int)tid);
            this.fOpenedElements.put(tid, openedElement);
            return openedElement;
        }
    }

    private static class OpenedElement {
        private final int fPid;
        private final int fTid;
        private final List<CallStackTestData.ExpectedFunction> fCalls = new ArrayList<CallStackTestData.ExpectedFunction>();

        OpenedElement(int pid, int tid) {
            this.fPid = pid;
            this.fTid = tid;
        }
    }

    private static class OpenedFunction {
        private final long fFctStart;
        private final String fFctName;
        private final List<CallStackTestData.ExpectedFunction> fChildren = new ArrayList<CallStackTestData.ExpectedFunction>();

        OpenedFunction(long fctStart, String fctName) {
            this.fFctStart = fctStart;
            this.fFctName = fctName;
        }

        CallStackTestData.ExpectedFunction closeFunction(long end) {
            return new CallStackTestData.ExpectedFunction((int)this.fFctStart, (int)end, this.fFctName, this.fChildren);
        }
    }
}

